% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pg_list_sets.R
\name{pg_list_sets}
\alias{pg_list_sets}
\title{List the set structure of the Pangaea repository}
\usage{
pg_list_sets(token = NULL, as = "df", ...)
}
\arguments{
\item{token}{(character) a token previously provided by the server to
resume a request where it last left off. 50 is max number of records
returned. We will loop for you internally to get all the records you
asked for.}

\item{as}{(character) What to return. One of "df" (for data.frame; default),
"list", or "raw" (raw text)}

\item{...}{Curl debugging options passed on to \code{\link[oai:list_sets]{oai::list_sets()}}}
}
\value{
XML character string, data.frame, or list, depending on what
requested with the \code{as} parameter
}
\description{
List the set structure of the Pangaea repository
}
\examples{
\dontrun{
pg_list_sets()
pg_list_sets(as = "list")
pg_list_sets(as = "raw")
}
}
\references{
\href{https://www.openarchives.org/pmh/}{OAI-PMH documentation}
}
\seealso{
wraps \code{\link[oai:list_sets]{oai::list_sets()}}

Other oai methods: \code{\link{pg_get_record}},
  \code{\link{pg_identify}},
  \code{\link{pg_list_identifiers}},
  \code{\link{pg_list_metadata_formats}},
  \code{\link{pg_list_records}}
}
