% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse-methods.R
\name{dplyr_verbs}
\alias{dplyr_verbs}
\alias{arrange}
\alias{filter}
\alias{distinct}
\alias{full_join}
\alias{group_by}
\alias{inner_join}
\alias{left_join}
\alias{mutate}
\alias{rename}
\alias{right_join}
\alias{sample_frac}
\alias{sample_n}
\alias{select}
\alias{slice}
\alias{summarise}
\alias{transmute}
\alias{ungroup}
\alias{arrange.ped}
\alias{group_by.ped}
\alias{ungroup.ped}
\alias{filter.ped}
\alias{sample_n.ped}
\alias{sample_frac.ped}
\alias{slice.ped}
\alias{select.ped}
\alias{mutate.ped}
\alias{rename.ped}
\alias{summarise.ped}
\alias{summarize.ped}
\alias{transmute.ped}
\alias{inner_join.ped}
\alias{full_join.ped}
\alias{left_join.ped}
\alias{right_join.ped}
\alias{arrange.nested_fdf}
\alias{group_by.nested_fdf}
\alias{ungroup.nested_fdf}
\alias{filter.nested_fdf}
\alias{sample_n.nested_fdf}
\alias{sample_frac.nested_fdf}
\alias{slice.nested_fdf}
\alias{select.nested_fdf}
\alias{mutate.nested_fdf}
\alias{rename.nested_fdf}
\alias{summarise.nested_fdf}
\alias{summarize.nested_fdf}
\alias{transmute.nested_fdf}
\alias{inner_join.nested_fdf}
\alias{full_join.nested_fdf}
\alias{left_join.nested_fdf}
\alias{right_join.nested_fdf}
\title{\code{dplyr} Verbs for \code{ped}-Objects}
\usage{
\method{arrange}{ped}(.data, ...)

\method{group_by}{ped}(.data, ..., .add = FALSE)

\method{ungroup}{ped}(x, ...)

\method{filter}{ped}(.data, ...)

\method{sample_n}{ped}(tbl, size, replace = FALSE, weight = NULL, .env = NULL, ...)

\method{sample_frac}{ped}(tbl, size = 1, replace = FALSE, weight = NULL, .env = NULL, ...)

\method{slice}{ped}(.data, ...)

\method{select}{ped}(.data, ...)

\method{mutate}{ped}(.data, ..., keep_attributes = TRUE)

\method{rename}{ped}(.data, ...)

\method{summarise}{ped}(.data, ...)

\method{summarize}{ped}(.data, ...)

\method{transmute}{ped}(.data, ...)

\method{inner_join}{ped}(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

\method{full_join}{ped}(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

\method{left_join}{ped}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep_attributes = TRUE
)

\method{right_join}{ped}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep_attributes = TRUE
)

\method{arrange}{nested_fdf}(.data, ...)

\method{group_by}{nested_fdf}(.data, ..., .add = FALSE)

\method{ungroup}{nested_fdf}(x, ...)

\method{filter}{nested_fdf}(.data, ...)

\method{sample_n}{nested_fdf}(tbl, size, replace = FALSE, weight = NULL, .env = NULL, ...)

\method{sample_frac}{nested_fdf}(tbl, size = 1, replace = FALSE, weight = NULL, .env = NULL, ...)

\method{slice}{nested_fdf}(.data, ...)

\method{select}{nested_fdf}(.data, ...)

\method{mutate}{nested_fdf}(.data, ..., keep_attributes = TRUE)

\method{rename}{nested_fdf}(.data, ...)

\method{summarise}{nested_fdf}(.data, ...)

\method{summarize}{nested_fdf}(.data, ...)

\method{transmute}{nested_fdf}(.data, ...)

\method{inner_join}{nested_fdf}(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

\method{full_join}{nested_fdf}(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

\method{left_join}{nested_fdf}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep_attributes = TRUE
)

\method{right_join}{nested_fdf}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep_attributes = TRUE
)
}
\arguments{
\item{.data}{an  object of class \code{ped}, see \code{\link{as_ped}}.}

\item{...}{see \code{dplyr} documentation}

\item{x}{an  object of class \code{ped}, see \code{\link{as_ped}}.}

\item{tbl}{an  object of class \code{ped}, see \code{\link{as_ped}}.}

\item{size}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>
For \code{sample_n()}, the number of rows to select.
For \code{sample_frac()}, the fraction of rows to select.
If \code{tbl} is grouped, \code{size} applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Sampling weights.
This must evaluate to a vector of non-negative numbers the same length as
the input. Weights are automatically standardised to sum to 1.}

\item{.env}{DEPRECATED.}

\item{keep_attributes}{conserve attributes? defaults to \code{TRUE}}

\item{y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{by}{A character vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so that you
can check they're correct; suppress the message by supplying \code{by} explicitly.

To join by different variables on \code{x} and \code{y}, use a named vector.
For example, \code{by = c("a" = "b")} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a vector with length > 1.
For example, \code{by = c("a", "b")} will match \code{x$a} to \code{y$a} and \code{x$b} to
\code{y$b}. Use a named vector to match different variables in \code{x} and \code{y}.
For example, \code{by = c("a" = "b", "c" = "d")} will match \code{x$a} to \code{y$b} and
\code{x$c} to \code{y$d}.

To perform a cross-join, generating all combinations of \code{x} and \code{y},
use \code{by = character()}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{funs}{see \code{\link[dplyr]{summarize_all}}}

\item{.dots}{see \code{dplyr} documentation}
}
\value{
a modified \code{ped} object (except for \code{do})
}
\description{
See \code{dplyr} documentation of the respective functions for
description and examples.
}
\keyword{internal}
