% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pal.maxdist}
\alias{pal.maxdist}
\title{Measure the maximum distance between two palettes}
\usage{
pal.maxdist(pal1, pal2, n = 255)
}
\arguments{
\item{pal1}{A color palette (function or vector)}

\item{pal2}{A color palette (function or vector)}

\item{n}{Number of colors to use, default 255}
}
\value{
Numeric value of the maximum distance.
}
\description{
Measure the maximum distance between two palettes
}
\details{
The distance between two palettes (of equal length) is calculated pointwise using
the Lab color space.  A 'just noticeable difference' between colors is roughly 2.3.
}
\examples{
pa0 <- c("#ff0000","#00ff00","#0000ff")
pa1 <- c("#fa0000","#00fa00","#0000fa") # 2.4
pa2 <- c("#f40000","#00f400","#0000f4") # 5.2
pal.maxdist(pa0,pa1) # 2.36
pal.maxdist(pa0,pa2) # 5.20
pal.bands(pa1,pa0,pa2, labels=c("2.36","0","5.20"))
title("Maximum Lab distance from middle palette")

# distance between colormap functions
pal.maxdist(coolwarm,warmcool)

}
\references{
https://en.wikipedia.org/wiki/Color_difference
}
\author{
Kevin Wright
}
