% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autopal.R
\name{autopal}
\alias{autopal}
\title{Auto-Palette}
\usage{
autopal(set = "", n = 30, limits = NA, bias = 1, legend_len = 6)
}
\arguments{
\item{set}{Colour set to use -- see ?autocol for full list. A default \code{sasha} or \code{viridis} is chosen if empty.}

\item{n}{Length of colour vector to return, must be at least 2}

\item{limits}{Colour scale limits to pass to legend eg \code{c(0,10)} -- if left as \code{NA} no autolegend will be generated}

\item{bias}{Skew to apply to colour-ramp (>1 increases resolution at low end, <1 at the high end)}

\item{legend_len}{Continuous legend target size}
}
\value{
A character vector of colours of length \code{n} giving a continuous colour palette sampled from \code{set}.
If \code{limits} are specified, information for a colour legend is produced of approximate length
\code{legend_len}. This is stored in \code{options('autolegend')} and not returned explicitly.
}
\description{
Return a palette vector from one of the built-in sets
}
\details{
This can be used where a palette is provided rather than a mapped colour
vector, for example \code{image()}. The limits must be specified for \code{autolegend()}
information to be updated.
Custom colour limits can be set using \code{breaks} or \code{levels} (see examples) if
the same colour range is needed across several plots.

See ?autocol for list of all available colour sets.
}
\examples{
image(volcano, col=autopal('RdYlGn', n=100, limits=c(50,200), bias=1.5),
    breaks=seq(50,200,length.out=101) )
  autolegend('bottom', inset=1, ncol=5)

# Or using the slightly smarter filled.contour
filled.contour(volcano, col=autopal('RdYlGn', n=20, limits=c(100,150)),
  levels=seq(50,200,length.out=21) )

}
