% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleModels.R
\name{opt.joint.GRW}
\alias{opt.joint.GRW}
\alias{opt.joint.URW}
\alias{opt.joint.Stasis}
\alias{opt.joint.StrictStasis}
\title{Fit evolutionary models using the "Joint" parameterization}
\usage{
opt.joint.GRW(
  y,
  pool = TRUE,
  cl = list(fnscale = -1),
  meth = "L-BFGS-B",
  hess = FALSE
)

opt.joint.URW(
  y,
  pool = TRUE,
  cl = list(fnscale = -1),
  meth = "L-BFGS-B",
  hess = FALSE
)

opt.joint.Stasis(
  y,
  pool = TRUE,
  cl = list(fnscale = -1),
  meth = "L-BFGS-B",
  hess = FALSE
)

opt.joint.StrictStasis(y, pool = TRUE, cl = list(fnscale = -1), hess = FALSE)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{pool}{if TRUE, sample variances are substituted with their pooled estimate}

\item{cl}{optional control list, passed to \code{optim()}}

\item{meth}{optimization algorithm, passed to \code{optim()}}

\item{hess}{if TRUE, return standard errors of parameter estimates from the
hessian matrix}
}
\value{
a \code{paleoTSfit} object with the model fitting results
}
\description{
Fit evolutionary models using the "Joint" parameterization
}
\details{
These functions use the joint distribution of population means to fit models
using a full maximum-likelihood approach. This approach was found to have somewhat
better performance than the "AD" approach, especially for noisy trends (Hunt, 2008).
}
\section{Functions}{
\itemize{
\item \code{opt.joint.URW()}: fit the URW model by the Joint parameterization

\item \code{opt.joint.Stasis()}: fit the Stasis model by the Joint parameterization

\item \code{opt.joint.StrictStasis()}: fit the Strict Stasis model by the Joint parameterization

}}
\note{
It is easier to use the convenience function \code{fitSimple}.
}
\examples{
x <- sim.GRW(ns = 20, ms = 1)  # strong trend
plot(x)
w.grw <- opt.joint.GRW(x)
w.urw <- opt.joint.URW(x)
compareModels(w.grw, w.urw)
}
\references{
#' Hunt, G., M. J. Hopkins and S. Lidgard. 2015. Simple versus complex models of trait evolution
and stasis as a response to environmental change. PNAS 112(16): 4885-4890.
}
\seealso{
\code{\link{fitSimple}}, \code{\link{opt.GRW}}
}
