% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{tree.ages}
\alias{tree.ages}
\title{Automatically build matrix for time-calibration of phylogenetic trees using occurrence data}
\usage{
tree.ages(phylo0 = NULL, data = NULL, taxa = phylo0$tip.label)
}
\arguments{
\item{phylo0}{(Optional) Object of class=="phylo" from which to draw taxa to include in calibration matrix}

\item{data}{Optional list()-object containing either taxon-range tables or occurrence datasets for all taxa. If NULL, data will be automatically downloaded via the pdb()-function}

\item{taxa}{Taxa to include in calibration matrix, defaults to phylo0$tip.label}
}
\value{
A two-column matrix containing earliest and latest occurrences for each taxon in taxa, with taxon names as row names
}
\description{
Automatically build matrix for time-calibration of phylogenetic trees using occurrence data
}
\examples{
data(archosauria)
data(tree_archosauria)
tree.ages(tree_archosauria,data=archosauria)->ages
}
