% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pald_functions.R
\name{community_graphs}
\alias{community_graphs}
\title{Community Graphs}
\usage{
community_graphs(c)
}
\arguments{
\item{c}{A \code{cohesion_matrix} object, a matrix of cohesion values
(see \code{\link{cohesion_matrix}}).}
}
\value{
A list consisting of:
\itemize{
\item \code{G}: the weighted (community) graph whose edge weights are mutual
cohesion
\item \code{G_strong}: the weighted (community) graph consisting of edges
for which mutual cohesion is greater than the threshold for strong
ties (see \code{\link{strong_threshold}})
\item \code{layout}: the layout, using the Fruchterman Reingold (FR)
force-directed graph drawing for the graph \code{G}
}
}
\description{
Provides the graphs whose edge weights are (mutual) cohesion, together with
a graph layout.
}
\details{
Constructs the graphs whose edge weights are (mutual) cohesion
(see \code{\link{cohesion_matrix}}), self-loops are removed.
The graph G has adjacency matrix equal to the symmetrized cohesion matrix
(using the entry-wise parallel minimum of C and its transpose).
The graph G_strong has adjacency matrix equal to the thresholded and
symmetrized cohesion matrix (see \code{\link{cohesion_strong}}).  The threshold is
equal to half of the average of the diagonal of the
cohesion matrix (see \code{\link{strong_threshold}}).

A layout is also computed using the Fruchterman-Reingold (FR)
force-directed graph drawing algorithm.  As a result, it may provide a
somewhat different layout each time it is run.
}
\examples{
C <- cohesion_matrix(dist(exdata2))
plot(community_graphs(C)$G_strong)
plot(community_graphs(C)$G_strong, layout = community_graphs(C)$layout)
}
