% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppm.R
\name{ppm_platforms}
\alias{ppm_platforms}
\title{List all platforms supported by Posit Package Manager (PPM)}
\usage{
ppm_platforms()
}
\value{
Data frame with columns:
\itemize{
\item \code{name}: platform name, this is essentially an identifier,
\item \code{os}: operating system, \code{linux}, \code{windows} or \code{macOS} currently,
\item \code{binary_url}: the URL segment of the binary repository URL of this
platform, see \code{\link[=ppm_snapshots]{ppm_snapshots()}}.
\item \code{distribution}: for Linux platforms the name of the distribution,
\item \code{release}: for Linux platforms, the name of the release,
\item \code{binaries}: whether PPM builds binaries for this platform.
}
}
\description{
List all platforms supported by Posit Package Manager (PPM)
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ppm_platforms()
\dontshow{\}) # examplesIf}
}
\seealso{
The 'pkgcache and Posit Package Manager on Linux'
article at \url{https://r-lib.github.io/pkgcache/}.

Other PPM functions: 
\code{\link{ppm_has_binaries}()},
\code{\link{ppm_r_versions}()},
\code{\link{ppm_repo_url}()},
\code{\link{ppm_snapshots}()}
}
\concept{PPM functions}
