% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\name{pkg_deps_tree}
\alias{pkg_deps_tree}
\title{Draw the dependency tree of a package}
\usage{
pkg_deps_tree(pkg, upgrade = TRUE, dependencies = NA)
}
\arguments{
\item{pkg}{Package name or remote package specification to resolve.}

\item{upgrade}{Whether to use the most recent available package
versions.}

\item{dependencies}{Dependency types. See
\code{\link[pkgdepends:as_pkg_dependencies]{pkgdepends::as_pkg_dependencies()}} for possible values.}
}
\value{
The same data frame (tibble) as \code{\link[=pkg_deps]{pkg_deps()}}, invisibly.
}
\description{
Draw the dependency tree of a package
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pkg_deps_tree("dplyr")
pkg_deps_tree("r-lib/usethis")
\dontshow{\}) # examplesIf}
}
\seealso{
Other package functions: 
\code{\link{lib_status}()},
\code{\link{pak_package_sources}},
\code{\link{pak}()},
\code{\link{pkg_deps}()},
\code{\link{pkg_download}()},
\code{\link{pkg_install}()},
\code{\link{pkg_remove}()},
\code{\link{pkg_status}()}
}
\concept{package functions}
