% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj.R
\name{proj_install}
\alias{proj_install}
\title{Install project dependencies into the project library}
\usage{
proj_install(pkg = NULL, root = ".", upgrade = FALSE,
  optional = FALSE, ask = interactive())
}
\arguments{
\item{pkg}{Package(s) to install. By default (if \code{NULL}), they are
taken from the \code{DESCRIPTION} file in \code{root}. If not \code{NULL}, then the
packages will be added to the \code{DESCRIPTION} files, and existing
references to these packages will be removed first.}

\item{root}{Path to the project directory. A subdirectory can be given
as well. Defaults to the current working directory.}

\item{upgrade}{Whether to try to install the latest available versions
of the specified package(s) and/or all dependencies.}

\item{optional}{If \code{pkg} is not \code{NULL}, then the new packages will be
added as optional, i.e. in the \code{Suggests} section.}

\item{ask}{Whether to ask the user for confirmation. For non-interactive
installs supply\code{FALSE} here.}
}
\value{
Data frame containing data about the installed / updated
packages.
}
\description{
The project library is in \code{r-packages}, within the project directory.
}
\seealso{
Other project functions: \code{\link{proj_create}},
  \code{\link{proj_install_dev}},
  \code{\link{proj_remove}}, \code{\link{proj_status}}
}
\concept{project functions}
\keyword{internal}
