% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PgR6.R
\name{PgR6}
\alias{PgR6}
\title{PgR6 basic class}
\description{
A basic \code{PgR6} class constructor. It contains basic fields
and subset functions to handle a pangenome. Final users should use \code{\link{pagoo}}
instead of this, since is more easy to understand.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{pan_matrix}}{The panmatrix. Rows are organisms, and
columns are groups of orthologous. Cells indicates the presence (>=1) or
absence (0) of a given gene, in a given organism. Cells can have values
greater than 1 if contain in-paralogs.}

\item{\code{organisms}}{A \code{\link[S4Vectors:DataFrame-class]{DataFrame}} with available
organism names, and organism number identifier as \code{rownames()}. (Dropped
organisms will not be displayed in this field, see \code{$dropped} below).
Additional metadata will be shown if provided, as additional columns.}

\item{\code{genes}}{A \code{\link[IRanges:DataFrameList-class]{SplitDataFrameList}} object with
one entry per cluster. Each element contains a \code{\link[S4Vectors:DataFrame-class]{DataFrame}}
with gene ids (\code{<gid>}) and additional metadata, if provided. \code{gid} are
created by \code{paste}ing organism and gene names, so duplication in gene names
are avoided.}

\item{\code{clusters}}{A \code{\link[S4Vectors:DataFrame-class]{DataFrame}} with the groups
of orthologous (clusters). Additional metadata will be shown as additional columns,
if provided before. Each row corresponds to each cluster.}

\item{\code{core_level}}{The percentage of organisms a gene must be in
to be considered as part of the coregenome. \code{core_level = 95} by default.
Can't be set above 100, and below 85 raises a warning.}

\item{\code{core_genes}}{Like \code{genes}, but only showing core genes.}

\item{\code{core_clusters}}{Like \code{$clusters}, but only showing core
clusters.}

\item{\code{cloud_genes}}{Like \code{genes}, but only showing cloud genes.
These are defined as those clusters which contain a single gene (singletons), plus
those which have more than one but its organisms are probably clonal due to identical
general gene content. Colloquially defined as strain-specific genes.}

\item{\code{cloud_clusters}}{Like \code{$clusters}, but only showing cloud
clusters as defined above.}

\item{\code{shell_genes}}{Like \code{genes}, but only showing shell genes.
These are defined as those clusters than don't belong neither to the core genome,
nor to cloud genome. Colloquially defined as genes that are present in some but not
all strains, and that aren't strain-specific.}

\item{\code{shell_clusters}}{Like \code{$clusters}, but only showing shell
clusters, as defined above.}

\item{\code{summary_stats}}{A \code{\link[S4Vectors:DataFrame-class]{DataFrame}} with
information about the number of core, shell, and cloud clusters, as well as the
total number of clusters.}

\item{\code{random_seed}}{The last \code{.Random.seed}. Used for
reproducibility purposes only.}

\item{\code{dropped}}{A \code{character} vector with dropped organism
names, and organism number identifier as \code{names()}}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PgR6$new()}}
\item \href{#method-add_metadata}{\code{PgR6$add_metadata()}}
\item \href{#method-drop}{\code{PgR6$drop()}}
\item \href{#method-recover}{\code{PgR6$recover()}}
\item \href{#method-write_pangenome}{\code{PgR6$write_pangenome()}}
\item \href{#method-save_pangenomeRDS}{\code{PgR6$save_pangenomeRDS()}}
\item \href{#method-clone}{\code{PgR6$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
A basic \code{PgR6} class constructor. It contains basic fields
and subset functions to handle a pangenome.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6$new(
  data,
  org_meta,
  cluster_meta,
  core_level = 95,
  sep = "__",
  verbose = TRUE,
  DF,
  group_meta
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{DataFrame}} containing at least the
following columns: \code{gene} (gene name), \code{org} (organism name to which the gene belongs to),
and \code{cluster} (group of orthologous to which the gene belongs to). More columns can be added as metadata
for each gene.}

\item{\code{org_meta}}{(optional) A \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{DataFrame}}
containing additional metadata for organisms. This \code{data.frame} must have a column named "org" with
valid organisms names (that is, they should match with those provided in \code{data}, column \code{org}), and
additional columns will be used as metadata. Each row should correspond to each organism.}

\item{\code{cluster_meta}}{(optional) A \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{DataFrame}}
containing additional metadata for clusters. This \code{data.frame} must have a column named "cluster" with
valid organisms names (that is, they should match with those provided in \code{data}, column \code{cluster}), and
additional columns will be used as metadata. Each row should correspond to each cluster.}

\item{\code{core_level}}{The initial core_level (that's the percentage of organisms a core cluster must be in to be
considered as part of the core genome). Must be a number between 100 and 85, (default: 95). You can change it
later by using the \code{$core_level} field once the object was created.}

\item{\code{sep}}{A separator. By default is '__'(two underscores). It will be used to
create a unique \code{gid} (gene identifier) for each gene. \code{gid}s are created by pasting
\code{org} to \code{gene}, separated by \code{sep}.}

\item{\code{verbose}}{\code{logical}. Whether to display progress messages when loading class.}

\item{\code{DF}}{Deprecated. Use \code{data} instead.}

\item{\code{group_meta}}{Deprecated. Use \code{cluster_meta} instead.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An R6 object of class PgR6. It contains basic fields and methods for
analyzing a pangenome.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-add_metadata}{}}}
\subsection{Method \code{add_metadata()}}{
Add metadata to the object. You can add metadata to each organism, to each
group of orthologous (cluster), or to each gene. Elements with missing data should be filled
by \code{NA} (dimensions of the provided data.frame must be coherent with object
data).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6$add_metadata(map = "org", data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{map}}{\code{character} identifying the metadata to map. Can
be one of \code{"org"}, \code{"cluster"}, or \code{"gid"}.}

\item{\code{data}}{\code{data.frame} or \code{DataFrame} with the metadata to
add. For each case, a column named as \code{"map"} must exists, which should
contain identifiers for each element. In the case of adding gene (\code{gid})
metadata,each gene should be referenced by the name of the organism and the name
of the gene as provided in the \code{"data"} data.frame, separated by the
 \code{"sep"} argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self} invisibly, but with additional metadata.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-drop"></a>}}
\if{latex}{\out{\hypertarget{method-drop}{}}}
\subsection{Method \code{drop()}}{
Drop an organism from the dataset. This method allows to hide an organism
from the real dataset, ignoring it in downstream analyses. All the fields and
methods will behave as it doesn't exist. For instance, if you decide to drop
organism 1, the \code{$pan_matrix} field (see below) would not show it when
called.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6$drop(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{character} or \code{numeric}. The name of the
organism wanted to be dropped, or its numeric id as returned in
\code{$organism} field (see below).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self} invisibly, but with \code{x} dropped. It isn't necessary
to assign the function call to a new object, nor to re-write it as R6 objects
are mutable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-recover"></a>}}
\if{latex}{\out{\hypertarget{method-recover}{}}}
\subsection{Method \code{recover()}}{
Recover a previously \code{$drop()}ped organism (see above). All fields
and methods will start to behave considering this organism again.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6$recover(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\code{character} or \code{numeric}. The name of the
organism wanted to be recover, or its numeric id as returned in
\code{$dropped} field (see below).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self} invisibly, but with \code{x} recovered. It isn't necessary
to assign the function call to a new object, nor to re-write it as R6 objects
are mutable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_pangenome"></a>}}
\if{latex}{\out{\hypertarget{method-write_pangenome}{}}}
\subsection{Method \code{write_pangenome()}}{
Write the pangenome data as flat tables (text). Is not the most recommended way
to save a pangenome, since you can loose information as numeric precision,
column classes (factor, numeric, integer), and the state of the object itself
(i.e. dropped organisms, or core_level), loosing reproducibility. Use
\code{$save_pangenomeRDS} for a more precise way of saving a pagoo object.
Still, it is useful if you want to work with the data outside R, just keep
the above in mind.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6$write_pangenome(dir = "pangenome", force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dir}}{The non-existing directory name where to put the data files. Default
is "pangenome".}

\item{\code{force}}{\code{logical}. Whether to overwrite the directory if it already
exists. Default: \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A directory with at least 3 files. "data.tsv" contain the basic
pangenome data as it is provided to the \code{data} argument in the
initialization method (\code{$new(...)}). "clusters.tsv" contain any metadata
associated to the clusters. "organisms.tsv" contain any metadata associated to
the organisms. The latter 2 files will contain a single column if no metadata
was provided.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_pangenomeRDS"></a>}}
\if{latex}{\out{\hypertarget{method-save_pangenomeRDS}{}}}
\subsection{Method \code{save_pangenomeRDS()}}{
Save a pagoo pangenome object. This function provides a method for saving a pagoo
object and its state into a "RDS" file. To load the pangenome, use the
\code{load_pangenomeRDS} function in this package. It *should* be compatible between
pagoo versions, so you could update pagoo and still recover the same pangenome. Even
\code{sep} and \code{core_level} are restored unless the user provides those
arguments in \code{load_pangenomeRDS}. \code{dropped} organisms also kept hidden, as
you where working with the original object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6$save_pangenomeRDS(file = "pangenome.rds")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{The name of the file to save. Default: "pangenome.rds".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Writes a list with all the information needed to restore the object by
using the load_pangenomeRDS function, into an RDS (binary) file.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
