% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makelist.R
\name{get_package_makelist}
\alias{get_package_makelist}
\title{Provide a \code{makelist} Suitable for Packages with \pkg{packager}}
\usage{
get_package_makelist(is_cran = FALSE, gitlab_token = NULL)
}
\arguments{
\item{is_cran}{Streamline \code{makelist} for usage on CRAN?}

\item{gitlab_token}{A private gitlab token. Used to query logs on
\url{https://gitlab.com}.}
}
\value{
A list for 
\code{\link[fakemake:make]{fakemake::make}}.
}
\description{
Provide a \code{makelist} Suitable for Packages with \pkg{packager}
}
\examples{
ml <- packager::get_package_makelist()
cbind(lapply(ml, function(x) x[["target"]]),
      lapply(ml, function(x) x[["alias"]]))

cl <- packager::get_package_makelist(is_cran = TRUE)
setdiff(sapply(ml, function(x) x[["target"]]),
        sapply(cl, function(x) x[["target"]]))
}
