% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2a_parameter_estimation_functions.R
\name{get_parameter_estimated_regression}
\alias{get_parameter_estimated_regression}
\title{Get the parameter values using the provided statistical regression methods}
\usage{
get_parameter_estimated_regression(
  param_to_be_estimated,
  data,
  method,
  indep_var,
  info_get_method,
  info_distribution = NA,
  covariates = NA,
  timevar_survival = NA,
  interaction = FALSE,
  fix_eff = NA,
  fix_eff_interact_vars = NA,
  random_intercept_vars = NA,
  nested_intercept_vars_pairs = NA,
  cross_intercept_vars_pairs = NA,
  uncorrel_slope_intercept_pairs = NA,
  random_slope_intercept_pairs = NA,
  naaction = "stats::na.omit",
  param2_to_be_estimated = NA,
  covariates2 = NA,
  interaction2 = FALSE,
  link = NA
)
}
\arguments{
\item{param_to_be_estimated}{parameter of interest}

\item{data}{data to be provided or the data file containing dataset}

\item{method}{method of estimation (for example, linear,
logistic regression etc)}

\item{indep_var}{the independent variable (column name in data file)}

\item{info_get_method}{additional information on methods
e.g Kaplan-Meier ot hazard}

\item{info_distribution}{distribution name  eg.
for logistic regression -binomial}

\item{covariates}{list of covariates-calculations to be done before passing}

\item{timevar_survival}{time variable for survival analysis}

\item{interaction}{boolean value to indicate interaction in the case of
linear regression}

\item{fix_eff}{boolean value to indicate interaction in the case of
linear regression}

\item{fix_eff_interact_vars}{boolean value to indicate interaction in the
case of linear regression}

\item{random_intercept_vars}{boolean value to indicate interaction in the
case of linear regression}

\item{nested_intercept_vars_pairs}{boolean value to indicate interaction in
the case of linear regression}

\item{cross_intercept_vars_pairs}{boolean value to indicate interaction in
the case of linear regression}

\item{uncorrel_slope_intercept_pairs}{boolean value to indicate interaction
in the case of linear regression}

\item{random_slope_intercept_pairs}{boolean value to indicate interaction
in the case of linear regression}

\item{naaction}{what action to be taken for the missing values, default
is a missing value.}

\item{param2_to_be_estimated}{parameter of interest for equation 2 in
bivariate regression}

\item{covariates2}{list of covariates - for equation 2 in
bivariate regression}

\item{interaction2}{boolean value to indicate interaction for equation
2 in bivariate regression}

\item{link}{link function to be provided if not using the default link
for each of the info_distribution}
}
\value{
the results of the regression analysis
}
\description{
Get the parameter values using the provided statistical regression methods
}
\details{
This function is the top in the layer of functions used for regression
analysis Thus it contains many parameters to be passed on
The required ones are parameter to be estimated, data that contains
the observation, the method of regression to be used, the independent
variable and the information for the distribution and method.
if the data is given as a file name. it will load the data in that file
Then it calls the appropriate functions depending on the regression method
that specified. The methods that are considered : Survival analysis,
linear regression, logistic regression,generalised linear model,
linear multilevel or mixed model, and seemingly unrelated regression
}
\examples{
\donttest{
result <- get_parameter_estimated_regression(
  param_to_be_estimated = "Direction",
  data = ISLR::Smarket, method = "logistic", indep_var = "Lag1",
  info_get_method = NA, info_distribution = "binomial",
  covariates = c("Lag2", "Lag3"), interaction = FALSE,
  naaction = "na.omit", link = NA)
  }
}
