% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSWHarvest.R
\docType{class}
\name{CSWHarvest}
\alias{CSWHarvest}
\title{CSWHarvest}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a CSW Harvest request
}
\description{
CSWHarvest

CSWHarvest
}
\note{
Class used internally by \pkg{ows4R} to trigger a CSW Harvest request
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{CSW}
\keyword{Harvest}
\keyword{OGC}
\section{Super classes}{
\code{\link[ows4R:OGCAbstractObject]{ows4R::OGCAbstractObject}} -> \code{\link[ows4R:OWSHttpRequest]{ows4R::OWSHttpRequest}} -> \code{CSWHarvest}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{Source}}{source property for request XML encoding}

\item{\code{ResourceType}}{resource type property for request XML encoding}

\item{\code{ResourceFormat}}{resource format property for request XML encoding}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CSWHarvest-new}{\code{CSWHarvest$new()}}
\item \href{#method-CSWHarvest-clone}{\code{CSWHarvest$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="ERROR"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-ERROR'><code>ows4R::OGCAbstractObject$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="INFO"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-INFO'><code>ows4R::OGCAbstractObject$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="WARN"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-WARN'><code>ows4R::OGCAbstractObject$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="encode"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-encode'><code>ows4R::OGCAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClass"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClass'><code>ows4R::OGCAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClassName"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClassName'><code>ows4R::OGCAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getNamespaceDefinition"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getNamespaceDefinition'><code>ows4R::OGCAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="isFieldInheritedFrom"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-isFieldInheritedFrom'><code>ows4R::OGCAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="logger"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-logger'><code>ows4R::OGCAbstractObject$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSHttpRequest" data-id="execute"><a href='../../ows4R/html/OWSHttpRequest.html#method-OWSHttpRequest-execute'><code>ows4R::OWSHttpRequest$execute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSHttpRequest" data-id="getCapabilities"><a href='../../ows4R/html/OWSHttpRequest.html#method-OWSHttpRequest-getCapabilities'><code>ows4R::OWSHttpRequest$getCapabilities()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSHttpRequest" data-id="getException"><a href='../../ows4R/html/OWSHttpRequest.html#method-OWSHttpRequest-getException'><code>ows4R::OWSHttpRequest$getException()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSHttpRequest" data-id="getRequest"><a href='../../ows4R/html/OWSHttpRequest.html#method-OWSHttpRequest-getRequest'><code>ows4R::OWSHttpRequest$getRequest()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSHttpRequest" data-id="getRequestHeaders"><a href='../../ows4R/html/OWSHttpRequest.html#method-OWSHttpRequest-getRequestHeaders'><code>ows4R::OWSHttpRequest$getRequestHeaders()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSHttpRequest" data-id="getResponse"><a href='../../ows4R/html/OWSHttpRequest.html#method-OWSHttpRequest-getResponse'><code>ows4R::OWSHttpRequest$getResponse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSHttpRequest" data-id="getResult"><a href='../../ows4R/html/OWSHttpRequest.html#method-OWSHttpRequest-getResult'><code>ows4R::OWSHttpRequest$getResult()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSHttpRequest" data-id="getStatus"><a href='../../ows4R/html/OWSHttpRequest.html#method-OWSHttpRequest-getStatus'><code>ows4R::OWSHttpRequest$getStatus()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSHttpRequest" data-id="setResult"><a href='../../ows4R/html/OWSHttpRequest.html#method-OWSHttpRequest-setResult'><code>ows4R::OWSHttpRequest$setResult()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSWHarvest-new"></a>}}
\if{latex}{\out{\hypertarget{method-CSWHarvest-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{CSWHarvest} service request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSWHarvest$new(
  capabilities,
  op,
  url,
  serviceVersion = "2.0.2",
  user = NULL,
  pwd = NULL,
  token = NULL,
  headers = list(),
  config = httr::config(),
  source = NULL,
  resourceType = "http://www.isotc211.org/schemas/2005/gmd/",
  resourceFormat = "application/xml",
  logger = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{capabilities}}{an object of class \link{CSWCapabilities}}

\item{\code{op}}{object of class \link{OWSOperation} as retrieved from capabilities}

\item{\code{url}}{url}

\item{\code{serviceVersion}}{serviceVersion. Default is "2.0.2}

\item{\code{user}}{user}

\item{\code{pwd}}{password}

\item{\code{token}}{token}

\item{\code{headers}}{headers}

\item{\code{config}}{config}

\item{\code{source}}{source}

\item{\code{resourceType}}{resource type. Default is "http://www.isotc211.org/schemas/2005/gmd/"}

\item{\code{resourceFormat}}{resource format. Default is "application/xml"}

\item{\code{logger}}{logger}

\item{\code{...}}{any parameter to pass to the service request}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CSWHarvest-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CSWHarvest-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CSWHarvest$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
