% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/container.R
\name{container-class}
\alias{container-class}
\alias{container_init}
\alias{container-methods}
\alias{start.container}
\alias{halt.container}
\alias{exec.container}
\alias{status.container}
\alias{copy.container}
\alias{run.container}
\title{Docker container class and methods}
\usage{
container_init(pkgnm)

\method{start}{container}(x)

\method{halt}{container}(x)

\method{exec}{container}(x, ...)

\method{status}{container}(x)

\method{copy}{container}(x, send = NULL, rtrn = NULL)

\method{run}{container}(x, cmd, args)
}
\arguments{
\item{pkgnm}{Package name}

\item{x}{container}

\item{...}{Arguments}

\item{send}{Filepaths to send from host computer to container.}

\item{rtrn}{Directory on host computer where returning files should be sent.}

\item{cmd}{Command name, character}

\item{args}{List or vector of arguments, character}
}
\value{
A list of class \code{container} with the following items:
\item{pkgnm}{Package name of the outsider module}
\item{prgrm}{Command to be called in the container}
\item{cntnr}{Unique Docker container name}
\item{img}{Image ID}
}
\description{
Return a list class that describes a Docker container.
The resulting class object comes with a series of convenience methods
for starting, stopping and interacting with a container.
}
\details{
All outsider modules have a \code{working_dir/} in which generated
files are created and initiation files must be for the program to use.
Files must be sent to this working directory and then returned before and
after the program has run.

If no \code{send} or \code{rtrn} specified, returns TRUE.
}
\seealso{
Other private-docker: 
\code{\link{docker_build}()},
\code{\link{docker_cmd}()},
\code{\link{docker_cp}()},
\code{\link{docker_img_rm}()},
\code{\link{docker_ps_count}()},
\code{\link{docker_pull}()}
}
\concept{private-docker}
