% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwasColocalisationForRegion.R
\name{gwasColocalisationForRegion}
\alias{gwasColocalisationForRegion}
\title{Retrieve GWAS colocalisation data for a genomic region .}
\usage{
gwasColocalisationForRegion(chromosome, start, end)
}
\arguments{
\item{chromosome}{String: Chromosome number as a string.}

\item{start}{Long: Start position of the specified chromosome.}

\item{end}{Long: End position of the specified chromosome.}
}
\value{
Returns a data frame with the following columns:
\itemize{
\item{\code{leftVariant.id}:} \emph{Character vector}. ID of the left variant.
\item{\code{leftVariant.position}:} \emph{Integer vector}. Position of the left variant.
\item{\code{leftVariant.chromosome}:} \emph{Character vector}. Chromosome of the left variant.
\item{\code{leftVariant.rsId}:} \emph{Character vector}. rsID of the left variant.
\item{\code{leftStudy.studyId}:} \emph{Character vector}. Study identifier for the left study.
\item{\code{leftStudy.traitReported}:} \emph{Character vector}. Reported trait associated with the colocalisation in the left study.
\item{\code{leftStudy.traitCategory}:} \emph{Character vector}. Category of the reported trait in the left study.
\item{\code{rightVariant.id}:} \emph{Character vector}. ID of the right variant.
\item{\code{rightVariant.position}:} \emph{Integer vector}. Position of the right variant.
\item{\code{rightVariant.chromosome}:} \emph{Character vector}. Chromosome of the right variant.
\item{\code{rightVariant.rsId}:} \emph{Character vector}. rsID of the right variant.
\item{\code{rightStudy.studyId}:} \emph{Character vector}. Study identifier for the right study.
\item{\code{rightStudy.traitReported}:} \emph{Character vector}. Reported trait associated with the colocalisation in the right study.
\item{\code{rightStudy.traitCategory}:} \emph{Character vector}. Category of the reported trait in the right study.
\item{\code{h3}:} \emph{Numeric vector}. H3 value associated with the colocalisation.
\item{\code{h4}:} \emph{Numeric vector}. H4 value associated with the colocalisation.
\item{\code{log2h4h3}:} \emph{Numeric vector}. Log2 ratio of H4 to H3 values associated with the colocalisation.
}
}
\description{
By providing a genomic region (chromosome name with start and end position), this function returns information about colocalisation
between GWAS studies and associated loci within a specified genomic region. It provides details on the
studies that have at least one overlapping associated locus within the region, allowing for the assessment
of potential shared causal variants.
The query output includes data such as the study identifiers, traits,
loci information, and other relevant attributes.
}
\examples{
\dontrun{
result <- gwasColocalisationForRegion(chromosome = "1", start = 153992685, end = 154155116)
}
}
\references{
- Giambartolomei, Claudia et al. “Bayesian test for colocalisation between pairs of
genetic association studies using summary statistics.” PLoS genetics vol. 10,5 e1004383. 15 May. 2014, doi:10.1371/journal.pgen.1004383
}
