% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmViaroute.R
\name{osrmViaroute}
\alias{osrmViaroute}
\title{Get Travel Time and Travel Distance Between Two Points}
\usage{
osrmViaroute(src, dst)
}
\arguments{
\item{src}{latitude and longitude of the origine point (numeric vector of length 2)}

\item{dst}{latitude and longitude of the destination point (numeric vector of length 2).}
}
\value{
A named numeric vector is returned. It contains travel time (in minutes) 
and travel distance (in kilometers).
}
\description{
Build and send an OSRM API query to get travel time and travel distance between two points.
This function interface the \emph{viaroute} OSRM service.
}
\examples{
\dontrun{
# Load data
data("com")
# Time and Distance between 2 points
route <- osrmViaroute(src = com[1,c("lat","lon")],
                      dst = com[15,c("lat","lon")] )
# Time travel distance (min)
route[1]
# Travel distance (km)
route[2]
# Mean Speed (km/h)
route[2]/(route[1]/60)
}
}
\seealso{
\link{osrmViarouteGeom}
}

