% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation-helpers.R
\name{validateIsOfType}
\alias{validateIsOfType}
\alias{validateIsCharacter}
\alias{validateIsString}
\alias{validateIsNumeric}
\alias{validateIsInteger}
\alias{validateIsLogical}
\title{Check if the provided object is of certain type. If not, stop with an error.}
\usage{
validateIsOfType(object, type, nullAllowed = FALSE)

validateIsCharacter(object, nullAllowed = FALSE)

validateIsString(object, nullAllowed = FALSE)

validateIsNumeric(object, nullAllowed = FALSE)

validateIsInteger(object, nullAllowed = FALSE)

validateIsLogical(object, nullAllowed = FALSE)
}
\arguments{
\item{object}{An object or an atomic vector or a list of objects.}

\item{type}{A single string or a vector of string representation or class of
the type that should be checked for.}

\item{nullAllowed}{Boolean flag if \code{NULL} is accepted for the \code{object}. If
\code{TRUE}, \code{NULL} always returns \code{TRUE}, otherwise \code{NULL} returns \code{FALSE}.
Default is \code{FALSE}.}
}
\value{
\code{NULL} if the entered object is of expected type, otherwise produces
error. Also accepts \code{NULL} as an input if \code{nullAllowed} argument is set to
\code{TRUE}.
}
\description{
Check if the provided object is of certain type. If not, stop with an error.
}
\examples{
A <- data.frame(
  col1 = c(1, 2, 3),
  col2 = c(4, 5, 6),
  col3 = c(7, 8, 9)
)

validateIsOfType(A, "data.frame")
validateIsInteger(5)
validateIsNumeric(1.2)
validateIsCharacter("x")
validateIsLogical(TRUE)
}
