% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/make-osm-map.R
\name{make_osm_map}
\alias{make_osm_map}
\title{make_osm_map}
\usage{
make_osm_map(filename = NULL, bbox = NULL, osm_data = NULL,
  structures = osm_structures(), width = 640, dat_prefix = "dat_")
}
\arguments{
\item{filename}{Name of plot file; default=NULL plots to screen device (low
quality and likely slow)}

\item{bbox}{the bounding box for the map.  A 2-by-2 matrix of 4 elements with
columns of min and max values, and rows of x and y values.  If NULL, bbox is
taken from the largest extent of OSM objects in osm_data.}

\item{osm_data}{A list of OSM objects as returned from extract_osm_objects().
These objects may be included in the plot without downloading. These should
all be named with the stated 'dat_prefix' and have suffixes as given in
'structures'.}

\item{structures}{A data.frame specifying types of OSM structures as returned
from osm_structures(), and potentially modified to alter lists of structures
to be plotted, and their associated colours. Objects are overlaid on plot
according to the order given in 'structures'.}

\item{width}{Width of graphics device, with height calculated according to
latitudinal and longitudinal proportions of 'bbox'.}

\item{dat_prefix}{Prefix for data structures (default 'dat_'). Final data
structures are created by appending the suffixes from osm_structures().}
}
\value{
list of OSM structures each as Spatial(Polygon/List)DataFrame, and
appended to `osm_data` (which is NULL by default).
}
\description{
Makes an entire OSM map for the given bbox using the submitted data, or by
downloading data if none submitted. This is a convenience function enabling
an entire map to be produced according to the graphical format specified with
the `structures` argument.
}
\section{Note}{

If 'osm_data=NULL', then data will be downloaded, which can take some time.
Progress is dumped to screen.
}

