/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.util.io;

import fr.ird.osmose.util.io.MetaFilenameFilter;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOTools {
    public static String resolvePath(String path) {
        String pathname = IOTools.resolveFile(path);
        if (!pathname.endsWith(File.separator)) {
            pathname = pathname + File.separator;
        }
        return pathname;
    }

    public static String resolveFile(String filename) {
        try {
            File file = new File(System.getProperty("user.dir"));
            String pathname = new File(file.toURI().resolve(new File(filename).toURI())).getAbsolutePath();
            return pathname;
        }
        catch (Exception e) {
            return filename;
        }
    }

    public static boolean makeDirectories(String file) throws SecurityException {
        String path = file.substring(0, file.lastIndexOf(File.separator));
        return new File(path).mkdirs();
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dest);
        FileChannel channelSrc = fis.getChannel();
        FileChannel channelDest = fos.getChannel();
        channelSrc.transferTo(0L, channelSrc.size(), channelDest);
        fis.close();
        fos.close();
    }

    public static String cleanFilePath(String filePath) {
        String fpath = filePath.replace('/', File.separatorChar);
        return fpath;
    }

    public static void backup(File src, String destDirectory) throws IOException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        formatter.setCalendar(calendar);
        StringBuffer bakfilePath = new StringBuffer(destDirectory);
        if (!destDirectory.endsWith(File.separator)) {
            bakfilePath.append(File.separator);
        }
        bakfilePath.append(src.getName());
        bakfilePath.append(".");
        bakfilePath.append(formatter.format(calendar.getTime()));
        File bakfile = new File(bakfilePath.toString());
        IOTools.makeDirectories(bakfilePath.toString());
        IOTools.copyFile(src, bakfile);
    }

    public static void backup(File src) throws IOException {
        String destDirectory = System.getProperty("user.dir");
        if (!destDirectory.endsWith(File.separator)) {
            destDirectory = destDirectory + File.separator;
        }
        destDirectory = destDirectory + "bak";
        IOTools.backup(src, destDirectory);
    }

    public static int getFileSize(URL url) {
        try {
            URLConnection connection = url.openConnection();
            return connection.getContentLength();
        }
        catch (IOException ex) {
            Logger.getLogger(IOTools.class.getName()).log(Level.SEVERE, null, ex);
            return 0;
        }
    }

    public static String getHumanFileSize(URL url) {
        return IOTools.fileSizeToHuman(IOTools.getFileSize(url));
    }

    public static String fileSizeToHuman(int filesize) {
        String[] sbytes = new String[]{"Kb", "Mb", "Gb"};
        float length = filesize;
        if (length < 1024.0f) {
            return "unknown size";
        }
        String unit = sbytes[0];
        for (int i = 0; i < sbytes.length && !(length / 1024.0f < 1.0f); ++i) {
            length /= 1024.0f;
            unit = sbytes[i];
        }
        NumberFormat dft = NumberFormat.getInstance(Locale.US);
        dft.setMaximumFractionDigits(1);
        dft.setMinimumFractionDigits(1);
        return dft.format(length) + " " + unit;
    }

    public static List<File> listFiles(File folder) {
        ArrayList<File> listf = new ArrayList<File>();
        File[] list = folder.listFiles();
        if (list != null) {
            for (File f : list) {
                if (f.isDirectory()) {
                    listf.addAll(IOTools.listFiles(f));
                    continue;
                }
                listf.add(f);
            }
        }
        return listf;
    }

    public static List<File> relativize(List<File> list, URI againstURI) {
        ArrayList<File> listrel = new ArrayList<File>(list.size());
        for (File f : list) {
            listrel.add(new File(againstURI.relativize(f.toURI()).toString()));
        }
        return listrel;
    }

    public static void deleteDirectoryOnExit(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                IOTools.deleteDirectoryOnExit(file);
            }
            file.deleteOnExit();
        }
        directory.deleteOnExit();
    }

    public static void deleteDirectory(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                IOTools.deleteDirectory(file);
            }
            file.delete();
        }
        directory.delete();
    }

    public static void deleteRecursively(String pathname, String pattern) {
        File path = new File(pathname);
        if (path.isDirectory()) {
            for (File file : path.listFiles(new MetaFilenameFilter(pattern))) {
                file.delete();
            }
            File[] list = path.listFiles();
            if (null != list) {
                for (File folder : list) {
                    if (!folder.isDirectory()) continue;
                    IOTools.deleteRecursively(folder.getAbsolutePath(), pattern);
                }
                if (list.length == 0) {
                    path.delete();
                }
            }
        }
    }

    public static void browse(URI uri) throws IOException {
        String[] commands;
        try {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(uri);
                return;
            }
        }
        catch (IOException desktop) {
            // empty catch block
        }
        for (String cmd : commands = new String[]{System.getenv("BROWSER"), "xdg-open", "kfmclient exec", "exo-open", "gnome-open", "firefox", "konqueror", "netscape"}) {
            if (cmd == null) continue;
            try {
                IOTools.browse(cmd, uri);
                return;
            }
            catch (IOException e) {
                System.err.println(cmd + " : " + e.getMessage());
            }
        }
        throw new IOException("No browser found.");
    }

    private static void browse(String command, URI uri) throws IOException {
        String[] args = command.split(" +");
        args = Arrays.copyOf(args, args.length + 1);
        args[args.length - 1] = uri.toString();
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(args);
        process.getOutputStream().close();
        process.getInputStream().close();
        process.getErrorStream().close();
    }
}

