/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.output.AbstractDistribOutput;
import fr.ird.osmose.output.distribution.AbstractDistribution;

public abstract class AbstractMeanDistribOutput
extends AbstractDistribOutput {
    double[][] denominator;

    public AbstractMeanDistribOutput(int rank, AbstractDistribution distrib) {
        super(rank, distrib);
    }

    @Override
    public void reset() {
        super.reset();
        this.denominator = new double[this.getNSpecies()][this.getNClass()];
    }

    @Override
    public void write(float time) {
        int nClass = this.getNClass();
        double[][] array = new double[nClass][this.getNSpecies() + 1];
        for (int iClass = 0; iClass < nClass; ++iClass) {
            array[iClass][0] = this.getClassThreshold(iClass);
            for (int iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
                array[iClass][iSpec + 1] = this.denominator[iSpec][iClass] != 0.0 ? this.values[iSpec][iClass] / this.denominator[iSpec][iClass] : Double.NaN;
            }
        }
        this.writeVariable(time, array);
    }
}

