#' @title skcm.clinical
#' @name skcm.clinical
#' @description The clinical variables of the SKCM dataset. The original data was obtained from The Cancer Genome Atlas (TCGA).
#' @usage skcm.clinical
#' @docType data
#' @format Contains 469 subjects with 156 failures. Each row contains one subject, subject ID is indicated by row name. Variables include \code{Time}, \code{Censor}, \code{Gender} and \code{Age}. \code{Age} has 8 missing values.
#' @references \url{https://cancergenome.nih.gov/}
#' @keywords skcm.clinical
NULL

#' @title skcm.melgene
#' @name skcm.melgene
#' @description The expression of top 20 genes of cutaneous melanoma literature based on the MelGene Database.
#' @usage skcm.melgene
#' @docType data
#' @format Each row contains one subject, subject ID is indicated by row name. Gene names in the columns. The columns are scaled.
#' @references Chatzinasiou, Foteini, Christina M. Lill, Katerina Kypreou, Irene Stefanaki, Vasiliki Nicolaou, George Spyrou, Evangelos Evangelou et al. "Comprehensive field synopsis and systematic meta-analyses of genetic association studies in cutaneous melanoma." Journal of the National Cancer Institute 103, no. 16 (2011): 1227-1235.
#' @references \url{http://bioinformatics.cing.ac.cy/MelGene/}
#' @references \url{https://cancergenome.nih.gov/}
#' @keywords skcm.melgene
NULL

