% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_img_dim.R
\name{dropImageDimension}
\alias{dropImageDimension}
\alias{drop_img_dim}
\title{Drop Image Dimension}
\usage{
dropImageDimension(img, onlylast = TRUE, warn = TRUE)

drop_img_dim(img, onlylast = TRUE, warn = TRUE)
}
\arguments{
\item{img}{nifti object}

\item{onlylast}{is a logical variable (default = \code{TRUE}).  Drop the 
dimension only if it is the last dimension.  For example, if \code{dim} is 
10x10x1x10 then no dimension is dropped, but if \code{dim} is 10x10x10x1 then 
it will be changed to 10x10x10.}

\item{warn}{produces a text output if the number of dimensions is under 
three.}
}
\value{
Object of class nifti
}
\description{
Drops a dimension of an image that has one-dimension and 
sets respective values to 0 in \code{pixdim} or 1 in \code{dim}.
}
\examples{

nim <- nifti(array(rnorm(10^3), dim = rep(10, 3)))
nim2 <- nifti(array(rnorm(10^3), dim = c(10, 10, 1, 10)))
dropImageDimension(nim2)
dropImageDimension(nim2, onlylast = FALSE)
nim3 <- nifti(array(rnorm(10^3), dim = c(10, 10, 10, 1)))
dropImageDimension(nim3)
dropImageDimension(nim3, onlylast = FALSE) # the same as above
nim4 <- nifti(array(rnorm(10^3), dim = c(10, 10, 10, 1, 10)))
dim(nim4[,,,1,])
dim(nim4[,,,1,,drop=TRUE])
dropImageDimension(nim4)

nim5 <- nifti(array(rnorm(10^4), dim = c(1, 10, 10, 10, 1, 10)))
dropImageDimension(nim5)
dropImageDimension(nim5, onlylast = FALSE)

nim6 <- nifti(array(rnorm(10^3), dim = c(1, 10, 10, 10, 1, 1)))
dropImageDimension(nim6)
\dontrun{
## 27 scans of Colin Holmes (MNI) brain co-registered and averaged
## NIfTI two-file format
URL <- "http://imaging.mrc-cbu.cam.ac.uk/downloads/Colin/colin_1mm.tgz"
urlfile <- file.path(tempdir(), "colin_1mm.tgz")
download.file(URL, dest=urlfile, quiet=TRUE)
untar(urlfile, exdir=tempdir())
colin <- readNIfTI(file.path(tempdir(), "colin_1mm"))
dim(colin)
dim_(colin)
pixdim(colin)
# this will error
writeNIfTI(colin, filename = tempfile())
colin <- dropImageDimension(colin)
writeNIfTI(colin, filename = tempfile())
}
}

