% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distsuml2.R
\name{distsuml2}
\alias{distsuml2}
\alias{distsuml2,loca.p-method}
\alias{distsuml2gra}
\alias{distsuml2gra,loca.p-method}
\title{distsuml2 and distsuml2gra at orloca package}
\usage{
distsuml2(o, x = 0, y = 0)
}
\arguments{
\item{o}{An object of \code{loca.p} class.}

\item{x}{The x coordinate of the point to be evaluated.}

\item{y}{The y coordinate of the point to be evaluated.}

\item{partial}{If (x,y) is a demand point \code{partial=T} means ignore such point to compute the gradient. This option is mainly for internal use.}
}
\value{
\code{distsuml2} returns the objective function of the min-sum location problem, \eqn{\sum_{a_i \in o} w_i d(a_i, (x,y))}, where \eqn{d(a_i, (x,y))} gives the euclidean distances between \eqn{a_i} and the point \eqn{(x,y)}.  \code{distsumgra} returns the gradient vector of the function \code{distsum}.
}
\description{
\code{distsum} and \code{distsumgra} functions for the Euclidean norm (\eqn{l_2}). Mainly for internal use.
}
\seealso{
See also \code{\link{orloca-package}}, \code{\link{distsum}}, \code{\link{distsumgra}} and \code{\link{distsummin}}.
}
\keyword{classes}
\keyword{internal}
\keyword{optimize}
