% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margins.R
\name{margins}
\alias{margins}
\title{Marginal Effects}
\usage{
margins(forest, eval = NULL, inference = NULL, window = NULL,
  newdata = NULL)
}
\arguments{
\item{forest}{estimated Ordered Forest object of class \code{orf}}

\item{eval}{string, defining evaluation point for marginal effects. These can be one of "mean", "atmean", or "atmedian". (Default is "mean")}

\item{inference}{logical, if TRUE inference on marginal effects will be conducted (default is inherited from the \code{orf} object)}

\item{window}{numeric, share of standard deviation of X to be used for evaluation of the marginal effect (default is 0.1)}

\item{newdata}{numeric matrix X containing the new observations for which the marginal effects should be estimated}
}
\description{
S3 generic method for estimation of marginal effects
of an Ordered Forest objects of class \code{orf}.
}
\examples{
## Ordered Forest
require(orf)

# load example data
data(odata)

# specify response and covariates
Y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

# estimate Ordered Forest
orf_fit <- orf(X, Y)
\donttest{
# estimate default marginal effects of the orf
orf_margins <- margins(orf_fit)
}

}
\seealso{
\code{\link{margins.orf}}, \code{\link{summary.margins.orf}} and \code{\link{print.margins.orf}}
}
\author{
Gabriel Okasa
}
