% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing.R
\name{orderly_example}
\alias{orderly_example}
\title{Set up an orderly example}
\usage{
orderly_example(
  name,
  path = tempfile(),
  run_demo = FALSE,
  quiet = FALSE,
  git = FALSE
)
}
\arguments{
\item{name}{Name of the example}

\item{path}{Destination to create the example - if it exists
already it must be an empty directory.  By default, creates a
new temporary directory}

\item{run_demo}{Logical, indicating if the example is configured
as a "demo" (i.e., with a set of reports to be run and
committed), should these be run?}

\item{quiet}{Logical, indicating if informational messages should
be suppressed when running the demo.}

\item{git}{Logical, indicating if we should create an basic git
repository along with the demo. This will have the default
orderly .gitignore set up, and a remote which is itself (so that
git pull and git fetch run without error, though they will do
nothing).}
}
\value{
Returns the path to the orderly example
}
\description{
Set up one of the orderly examples included with the package.
These are not intended to be starting points for new orderly
repositories, but are used in the package examples and vignettes.
}
\examples{
# Create a new copy of the "minimal" example
path <- orderly::orderly_example("minimal")
dir(path)

# Example reports within this repository:
orderly::orderly_list(path)
}
