% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/optparse.R
\name{OptionParser}
\alias{OptionParser}
\title{A function to create an instance of a parser object}
\usage{
OptionParser(usage = "usage: \%prog [options]", option_list = list(),
  add_help_option = TRUE, prog = NULL, description = "", epilogue = "")
}
\arguments{
\item{usage}{The program usage message that will printed out if
\code{parse_args} finds a help option, \code{\%prog} is substituted with the
value of the \code{prog} argument.}

\item{option_list}{A list of of \code{OptionParserOption} instances that will
define how \code{parse_args} reacts to command line options.
\code{OptionParserOption} instances are usually created by \code{make_option}
and can also be added to an existing \code{OptionParser} instance via the
\code{add_option} function.}

\item{add_help_option}{Whether a standard help option should be automatically
added to the \code{OptionParser} instance.}

\item{prog}{Program name to be substituted for \code{\%prog} in the usage
message (including description and epilogue if present),
the default is to use the actual Rscript file name if called by an
Rscript file and otherwise keep \code{\%prog}.}

\item{description}{Additional text for \code{print_help} to print out between
usage statement and options statement}

\item{epilogue}{Additional text for \code{print_help} to print out after
the options statement}
}
\value{
An instance of the \code{OptionParser} class.
}
\description{
This function is used to create an instance of a parser object
which when combined with the \code{parse_args}, \code{make_option}, and \code{add_option}
methods is very useful for parsing options from the command line.
}
\author{
Trevor Davis.
}
\references{
Python's \code{optparse} library, which inspired this package,
   is described here: \url{http://docs.python.org/library/optparse.html}
}
\seealso{
\code{\link{parse_args}} \code{\link{make_option}}
    \code{\link{add_option}}
}

