% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment.R
\name{augment_design}
\alias{augment_design}
\title{Augment Design}
\usage{
augment_design(
  init_design,
  alpha,
  model,
  parameters,
  par_values,
  design_space,
  calc_optimal_design,
  weight_fun = function(x) 1
)
}
\arguments{
\item{init_design}{A dataframe with "Point" and "Weight" columns that represents the initial design to augment}

\item{alpha}{Combined weight of the new points}

\item{model}{Formula that represent the model with x as the unknown}

\item{parameters}{Character vector with the unknown parameters of the model to estimate}

\item{par_values}{Numeric vector with the initial values of the unknown parameters}

\item{design_space}{Numeric vector with the extremes of the space of the design}

\item{calc_optimal_design}{Boolean parameter, if TRUE, the optimal design is calculated and efficiencies of the initial and augmented design are given}

\item{weight_fun}{Optional one variable function that represents the square of the structure of variance, in case of heteroscedastic variance of the response}
}
\value{
A dataframe that represents the D-augmented design
}
\description{
D-Augments a design. The user gives an initial design for which he would like to add points
and specifies the weight of the new points. Then he is prompted to choose a
minimum efficiency. After that, the candidate points region is calculated
and the user can choose the points and weights to add.
}
\examples{
init_des <- data.frame("Point" = c(30, 60, 90), "Weight" = c(1/3, 1/3, 1/3))
augment_design(init_des, 0.25, y ~ 10^(a-b/(c+x)), c("a","b","c"),
  c(8.07131,  1730.63, 233.426), c(1, 100), TRUE)
augment_design(init_des, 0.25, y ~ 10^(a-b/(c+x)), c("a","b","c"),
  c(8.07131,  1730.63, 233.426), c(1, 100), FALSE)
}
