% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizationProblem-methods.R
\name{OptimizationProblem-methods}
\alias{OptimizationProblem-methods}
\alias{nrow}
\alias{ncol}
\alias{ncell}
\alias{modelsense}
\alias{vtype}
\alias{obj}
\alias{pwlobj}
\alias{A}
\alias{rhs}
\alias{sense}
\alias{lb}
\alias{ub}
\alias{col_ids}
\alias{row_ids}
\alias{get_data}
\alias{number_of_branches}
\alias{ncell,OptimizationProblem-method}
\alias{A,OptimizationProblem-method}
\alias{col_ids,OptimizationProblem-method}
\alias{lb,OptimizationProblem-method}
\alias{modelsense,OptimizationProblem-method}
\alias{ncol,OptimizationProblem-method}
\alias{nrow,OptimizationProblem-method}
\alias{obj,OptimizationProblem-method}
\alias{pwlobj,OptimizationProblem-method}
\alias{rhs,OptimizationProblem-method}
\alias{row_ids,OptimizationProblem-method}
\alias{sense,OptimizationProblem-method}
\alias{ub,OptimizationProblem-method}
\alias{vtype,OptimizationProblem-method}
\alias{number_of_branches,OptimizationProblem-method}
\alias{get_data,OptimizationProblem-method}
\title{Optimization problem methods}
\usage{
nrow(x)

\S4method{nrow}{OptimizationProblem}(x)

ncol(x)

\S4method{ncol}{OptimizationProblem}(x)

ncell(x)

\S4method{ncell}{OptimizationProblem}(x)

modelsense(x)

\S4method{modelsense}{OptimizationProblem}(x)

vtype(x)

\S4method{vtype}{OptimizationProblem}(x)

obj(x)

\S4method{obj}{OptimizationProblem}(x)

pwlobj(x)

\S4method{pwlobj}{OptimizationProblem}(x)

A(x)

\S4method{A}{OptimizationProblem}(x)

rhs(x)

\S4method{rhs}{OptimizationProblem}(x)

sense(x)

\S4method{sense}{OptimizationProblem}(x)

lb(x)

\S4method{lb}{OptimizationProblem}(x)

ub(x)

\S4method{ub}{OptimizationProblem}(x)

col_ids(x)

\S4method{col_ids}{OptimizationProblem}(x)

row_ids(x)

\S4method{row_ids}{OptimizationProblem}(x)

number_of_branches(x)

\S4method{number_of_branches}{OptimizationProblem}(x)

get_data(x)

\S4method{get_data}{OptimizationProblem}(x)
}
\arguments{
\item{x}{\linkS4class{OptimizationProblem} object.}
}
\value{
\code{list}, \link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix}, \code{numeric}
vector, \code{numeric} vector, or scalar \code{integer} depending on the
method used.
}
\description{
These functions are used to access data from an
\linkS4class{OptimizationProblem} object.
}
\details{
The functions return the following data:

\describe{

\item{nrow}{\code{integer} number of rows (constraints).}

\item{ncol}{\code{integer} number of columns (decision variables).}

\item{ncell}{\code{integer} number of cells.}

\item{modelsense}{\code{character} describing if the problem is to be
maximized (\code{"max"}) or minimized (\code{"min"}).}

\item{vtype}{\code{character} describing the type of each decision variable:
binary (\code{"B"}), semi-continuous (\code{"S"}), or continuous
(\code{"C"})}

\item{obj}{\code{numeric} vector defining the linear components of the
objective function.}

\item{pwlobj}{\code{list} object defining the piece-wise linear components
of the objective function.}

\item{A}{\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix} matrix object defining the
problem matrix.}

\item{rhs}{\code{numeric} vector with right-hand-side linear constraints}

\item{sense}{\code{character} vector with the senses of the linear
constraints (\code{"<="}, \code{">="}, \code{"="}).}

\item{lb}{\code{numeric} lower bound for each decision variable. Missing data
values (\code{NA}) indicate no lower bound for a given variable.}

\item{ub}{\code{numeric} upper bounds for each decision variable. Missing
data values (\code{NA}) indicate no upper bound for a given variable.}

\item{number_of_projects}{\code{integer} number of projects in the problem.}

\item{number_of_actions}{\code{integer} number of actions in the problem.}

\item{number_of_features}{\code{integer} number of features in the problem.}

\item{number_of_branches}{\code{integer} number of phylogenetic branches in
the problem.}

}
}
