% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_worksheet}
\alias{wb_add_worksheet}
\title{Add a worksheet to a workbook}
\usage{
wb_add_worksheet(
  wb,
  sheet = next_sheet(),
  grid_lines = TRUE,
  row_col_headers = TRUE,
  tab_color = NULL,
  zoom = 100,
  header = NULL,
  footer = NULL,
  odd_header = header,
  odd_footer = footer,
  even_header = header,
  even_footer = footer,
  first_header = header,
  first_footer = footer,
  visible = c("true", "false", "hidden", "visible", "veryhidden"),
  has_drawing = FALSE,
  paper_size = getOption("openxlsx2.paperSize", default = 9),
  orientation = getOption("openxlsx2.orientation", default = "portrait"),
  hdpi = getOption("openxlsx2.hdpi", default = getOption("openxlsx2.dpi", default = 300)),
  vdpi = getOption("openxlsx2.vdpi", default = getOption("openxlsx2.dpi", default = 300)),
  ...
)
}
\arguments{
\item{wb}{A Workbook object to attach the new worksheet}

\item{sheet}{A name for the new worksheet}

\item{grid_lines}{A logical. If \code{FALSE}, the worksheet grid lines will be
hidden.}

\item{row_col_headers}{A logical. If \code{FALSE}, the worksheet colname and rowname will be
hidden.}

\item{tab_color}{Color of the worksheet tab. A valid color (belonging to
colors()) or a valid hex color beginning with "#"}

\item{zoom}{A numeric between 10 and 400. Worksheet zoom level as a
percentage.}

\item{header, odd_header, even_header, first_header, footer, odd_footer, even_footer, first_footer}{Character vector of length 3 corresponding to positions left, center,
right.  \code{header} and \code{footer} are used to default additional arguments.
Setting \code{even}, \code{odd}, or \code{first}, overrides \code{header}/\code{footer}. Use \code{NA} to
skip a position.}

\item{visible}{If FALSE, sheet is hidden else visible.}

\item{has_drawing}{If TRUE prepare a drawing output (TODO does this work?)}

\item{paper_size}{An integer corresponding to a paper size. See \code{\link[=wb_page_setup]{wb_page_setup()}} for
details.}

\item{orientation}{One of "portrait" or "landscape"}

\item{hdpi}{Horizontal DPI. Can be set with options("openxlsx2.dpi" = X) or
options("openxlsx2.hdpi" = X)}

\item{vdpi}{Vertical DPI. Can be set with options("openxlsx2.dpi" = X) or
options("openxlsx2.vdpi" = X)}

\item{...}{...}
}
\value{
The \link{wbWorkbook} object \code{wb}
}
\description{
Add a worksheet to a workbook
}
\details{
Headers and footers can contain special tags \itemize{
\item{\strong{&[Page]}}{ Page number} \item{\strong{&[Pages]}}{ Number of pages}
\item{\strong{&[Date]}}{ Current date} \item{\strong{&[Time]}}{ Current time}
\item{\strong{&[Path]}}{ File path} \item{\strong{&[File]}}{ File name}
\item{\strong{&[Tab]}}{ Worksheet name} }
}
\examples{
## Create a new workbook
wb <- wb_workbook("Fred")

## Add 3 worksheets
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2", gridLines = FALSE)
wb$add_worksheet("Sheet 3", tabColor = "red")
wb$add_worksheet("Sheet 4", gridLines = FALSE, tabColor = "#4F81BD")

## Headers and Footers
wb$add_worksheet("Sheet 5",
  header = c("ODD HEAD LEFT", "ODD HEAD CENTER", "ODD HEAD RIGHT"),
  footer = c("ODD FOOT RIGHT", "ODD FOOT CENTER", "ODD FOOT RIGHT"),
  evenHeader = c("EVEN HEAD LEFT", "EVEN HEAD CENTER", "EVEN HEAD RIGHT"),
  evenFooter = c("EVEN FOOT RIGHT", "EVEN FOOT CENTER", "EVEN FOOT RIGHT"),
  firstHeader = c("TOP", "OF FIRST", "PAGE"),
  firstFooter = c("BOTTOM", "OF FIRST", "PAGE")
)

wb$add_worksheet("Sheet 6",
  header = c("&[Date]", "ALL HEAD CENTER 2", "&[Page] / &[Pages]"),
  footer = c("&[Path]&[File]", NA, "&[Tab]"),
  firstHeader = c(NA, "Center Header of First Page", NA),
  firstFooter = c(NA, "Center Footer of First Page", NA)
)

wb$add_worksheet("Sheet 7",
  header = c("ALL HEAD LEFT 2", "ALL HEAD CENTER 2", "ALL HEAD RIGHT 2"),
  footer = c("ALL FOOT RIGHT 2", "ALL FOOT CENTER 2", "ALL FOOT RIGHT 2")
)

wb$add_worksheet("Sheet 8",
  firstHeader = c("FIRST ONLY L", NA, "FIRST ONLY R"),
  firstFooter = c("FIRST ONLY L", NA, "FIRST ONLY R")
)

## Need data on worksheet to see all headers and footers
wb$add_data(sheet = 5, 1:400)
wb$add_data(sheet = 6, 1:400)
wb$add_data(sheet = 7, 1:400)
wb$add_data(sheet = 8, 1:400)
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_base_font}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_col_widths}},
\code{\link{wb_copy_cells}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_grouping}},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
