% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_data_table}
\alias{wb_add_data_table}
\title{Add data to a worksheet as an Excel table}
\usage{
wb_add_data_table(
  wb,
  sheet = current_sheet(),
  x,
  startCol = 1,
  startRow = 1,
  dims = rowcol_to_dims(startRow, startCol),
  xy = NULL,
  colNames = TRUE,
  rowNames = FALSE,
  tableStyle = "TableStyleLight9",
  tableName = NULL,
  withFilter = TRUE,
  sep = ", ",
  firstColumn = FALSE,
  lastColumn = FALSE,
  bandedRows = TRUE,
  bandedCols = FALSE,
  applyCellStyle = TRUE,
  removeCellStyle = FALSE,
  na.strings
)
}
\arguments{
\item{wb}{A Workbook object containing a #' worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{A dataframe.}

\item{startCol}{A vector specifying the starting column to write df}

\item{startRow}{A vector specifying the starting row to write df}

\item{dims}{Spreadsheet dimensions that will determine startCol and startRow: "A1", "A1:B2", "A:B"}

\item{xy}{An alternative to specifying startCol and startRow individually. A
vector of the form c(startCol, startRow)}

\item{colNames}{If \code{TRUE}, column names of x are written.}

\item{rowNames}{If \code{TRUE}, row names of x are written.}

\item{tableStyle}{Any excel table style name or "none" (see "formatting"
vignette).}

\item{tableName}{name of table in workbook. The table name must be unique.}

\item{withFilter}{If \code{TRUE}, columns with have filters in the first row.}

\item{sep}{Only applies to list columns. The separator used to collapse list
columns to a character vector e.g. sapply(x$list_column, paste, collapse =
sep).
\cr\cr
\cr\strong{The below options correspond to Excel table options:}
\cr
\if{html}{\figure{tableoptions.png}{options: width="40\%" alt="Figure: table_options.png"}}
\if{latex}{\figure{tableoptions.pdf}{options: width=7cm}}}

\item{firstColumn}{logical. If TRUE, the first column is bold}

\item{lastColumn}{logical. If TRUE, the last column is bold}

\item{bandedRows}{logical. If TRUE, rows are colour banded}

\item{bandedCols}{logical. If TRUE, the columns are colour banded}

\item{applyCellStyle}{Should we write cell styles to the workbook}

\item{removeCellStyle}{keep the cell style?}

\item{na.strings}{optional}
}
\description{
Add data to a worksheet and format as an Excel table
}
\details{
columns of x with class Date/POSIXt, currency, accounting,
hyperlink, percentage are automatically styled as dates, currency,
accounting, hyperlinks, percentages respectively. The string \code{"_openxlsx_NA"}
is reserved for \code{openxlsx2}. If the data frame contains this string, the
output will be broken.
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_get_base_font}()},
\code{\link{wb_save}()},
\code{\link{wb_set_col_widths}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()},
\code{\link{workbook_grouping}},
\code{\link{ws_cell_merge}}
}
\concept{workbook wrappers}
