% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{saveWorkbook}
\alias{saveWorkbook}
\title{save Workbook to file}
\usage{
saveWorkbook(wb, file, overwrite = FALSE, returnValue = FALSE)
}
\arguments{
\item{wb}{A Workbook object to write to file}

\item{file}{A character string naming an xlsx file}

\item{overwrite}{If \code{TRUE}, overwrite any existing file.}

\item{returnValue}{If \code{TRUE}, returns  \code{TRUE} in case of a success, else \code{FALSE}. 
If flag is \code{FALSE}, then no return value is returned.}
}
\description{
save a Workbook object to file
}
\examples{
## Create a new workbook and add a worksheet
wb <- createWorkbook("Creator of workbook")
addWorksheet(wb, sheetName = "My first worksheet")

## Save workbook to working directory
\dontrun{
saveWorkbook(wb, file = "saveWorkbookExample.xlsx", overwrite = TRUE)
}
}
\seealso{
\code{\link{createWorkbook}}

\code{\link{addWorksheet}}

\code{\link{loadWorkbook}}

\code{\link{writeData}}

\code{\link{writeDataTable}}
}
\author{
Alexander Walker, Philipp Schauberger
}
