% Generated by roxygen2 (4.0.1): do not edit by hand
\name{conditionalFormat}
\alias{conditionalFormat}
\title{Add conditional formatting to cells}
\usage{
conditionalFormat(wb, sheet, cols, rows, rule, style = NULL,
  type = "expression")
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{cols}{Columns to apply conditional formatting to}

\item{rows}{Rows to apply conditional formatting to}

\item{rule}{The condition under which to apply the formatting or a vector of colours
if type = "colourScale". See examples.}

\item{style}{A style to apply to those cells that satisify the rule. A Style object returned from createStyle()}

\item{type}{Either 'expression' or 'colorscale'. If 'expression' the formatting is determined
by a formula.  If colorScale cells are coloured based on cell value. See examples.}
}
\description{
Add conditional formatting to cells
}
\details{
Valid operators are "<", "<=", ">", ">=", "==", "!=". See Examples.
Default style given by: createStyle(fontColour = "#9C0006", bgFill = "#FFC7CE")
}
\examples{
wb <- createWorkbook()
addWorksheet(wb, "cellIs")
addWorksheet(wb, "moving Row")
addWorksheet(wb, "moving Col")
addWorksheet(wb, "Dependent on 1")
addWorksheet(wb, "colourScale 2 Colours")

negStyle <- createStyle(fontColour = "#9C0006", bgFill = "#FFC7CE")
posStyle <- createStyle(fontColour = "#006100", bgFill = "#C6EFCE")

## rule applies to all each cell in range
writeData(wb, 1, -5:5)
writeData(wb, 1, LETTERS[1:11], startCol=2)
conditionalFormat(wb, 1, cols=1, rows=1:11, rule="!=0", style = negStyle)
conditionalFormat(wb, 1, cols=1, rows=1:11, rule="==0", style = posStyle)

## highlight row dependent on first cell in row
writeData(wb, 2, -5:5)
writeData(wb, 2, LETTERS[1:11], startCol=2)
conditionalFormat(wb, 2, cols=1:2, rows=1:11, rule="$A1<0", style = negStyle)
conditionalFormat(wb, 2, cols=1:2, rows=1:11, rule="$A1>0", style = posStyle)

## highlight column dependent on first cell in column
writeData(wb, 3, -5:5)
writeData(wb, 3, LETTERS[1:11], startCol=2)
conditionalFormat(wb, 3, cols=1:2, rows=1:11, rule="A$1<0", style = negStyle)
conditionalFormat(wb, 3, cols=1:2, rows=1:11, rule="A$1>0", style = posStyle)


## highlight entire range cols X rows dependent only on cell A1
writeData(wb, 4, -5:5)
writeData(wb, 4, LETTERS[1:11], startCol=2)
conditionalFormat(wb, 4, cols=1:2, rows=1:11, rule="$A$1<0", style = negStyle)
conditionalFormat(wb, 4, cols=1:2, rows=1:11, rule="$A$1>0", style = posStyle)

## colourscale colours cells based on cell value

df <- read.xlsx(system.file("readTest.xlsx", package = "openxlsx"), sheet = 5)
writeData(wb, 5, df, colNames=FALSE)  ## write data.frame

## rule is a vector or colours of length 2 or 3 (any hex colour or any of colours())
conditionalFormat(wb, 5, cols=1:ncol(df), rows=1:nrow(df),
   rule =c("black", "white"), type = "colourScale")

setColWidths(wb, 5, cols=1:ncol(df), widths=1.07)
setRowHeights(wb, 5, rows=1:nrow(df), heights=7.5)

## Save workbook
saveWorkbook(wb, "conditionalFormatExample.xlsx", overwrite = TRUE)
}
\author{
Alexander Walker
}
\seealso{
\code{\link{createStyle}}
}

