% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.R
\name{aes_cbc}
\alias{aes_cbc}
\alias{aes_ctr_encrypt}
\alias{aes_ctr_decrypt}
\alias{aes_cbc_encrypt}
\alias{aes_cbc_decrypt}
\alias{aes_gcm_encrypt}
\alias{aes_gcm_decrypt}
\alias{aes_keygen}
\title{Symmetric AES encryption}
\usage{
aes_ctr_encrypt(data, key, iv = rand_bytes(16))

aes_ctr_decrypt(data, key, iv = attr(data, "iv"))

aes_cbc_encrypt(data, key, iv = rand_bytes(16))

aes_cbc_decrypt(data, key, iv = attr(data, "iv"))

aes_gcm_encrypt(data, key, iv = rand_bytes(16))

aes_gcm_decrypt(data, key, iv = attr(data, "iv"))

aes_keygen(length = 16)
}
\arguments{
\item{data}{raw vector or path to file with data to encrypt or decrypt}

\item{key}{raw vector of length 16, 24 or 32, e.g. the hash of a shared secret}

\item{iv}{raw vector of length 16 (aes block size) or NULL. The initialization vector
is not secret but should be random}

\item{length}{how many bytes to generate. Usually 16 (128-bit) or 12 (92-bit) for \code{aes_gcm}}
}
\description{
Low-level symmetric encryption/decryption using the AES block cipher in CBC mode.
The key is a raw vector, for example a hash of some secret. When no shared
secret is available, a random key can be used which is exchanged via an
asymettric protocol such as RSA. See \code{\link{rsa_encrypt}} for a worked example
or \code{\link{encrypt_envelope}} for a high-level wrapper combining AES and RSA.
}
\examples{
# aes-256 requires 32 byte key
passphrase <- charToRaw("This is super secret")
key <- sha256(passphrase)

# symmetric encryption uses same key for decryption
x <- serialize(iris, NULL)
y <- aes_cbc_encrypt(x, key = key)
x2 <- aes_cbc_decrypt(y, key = key)
stopifnot(identical(x, x2))
}

