% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pois.R
\name{ors_pois}
\alias{ors_pois}
\title{Openrouteservice POIs}
\usage{
ors_pois(
  request = c("pois", "stats", "list"),
  geometry,
  ...,
  api_key = ors_api_key(),
  output = c("parsed", "text", "sf")
)
}
\arguments{
\item{request}{One of the following: \code{"pois"}, \code{"stats"} or \code{"list"}}

\item{geometry}{named list containing either a \code{geojson} geometry object
(GeoJSON Point, LineString or Polygon) or a \code{bbox}, optionally buffered by
a value provided  \code{buffer}}

\item{...}{Optional request attributes as described \href{https://openrouteservice.org/dev/#/api-docs/pois/post}{here}}

\item{api_key}{Character scalar containing openrouteservice API key}

\item{output}{Output format. By default the response is being parsed to a list-based R object}
}
\value{
A list of points of interest in the area specified in \code{geometry} structured according to \code{output}:

\itemize{
\item for \code{"text"}, a character vector of length 1 re-encoded to UTF-8.
}

\itemize{
\item for \code{"parsed"}, a parsed R object.
}

\itemize{
\item for \code{"sf"}, a simple features \code{\link[sf]{sf}} object. Valid only for argument \code{request = "pois"}.
}
}
\description{
Search for points of interest around points or in geometries.
}
\details{
There are three different request types: \code{pois}, \code{stats} and \code{list}.

\code{pois} returns a GeoJSON FeatureCollection in the bounding box specified in
\code{geometry$bbox} or a GeoJSON geometry provided in \code{geometry$geojson}. \code{stats}
does the same but groups by categories, ultimately returning a JSON object
with the absolute numbers of POIs of a certain group.

\code{list} returns a list of category groups and their ids.
}
\examples{
\donttest{# POI categories list
ors_pois('list')

# POIs around a buffered point
geometry <- list(geojson = list(type = "Point",
                                coordinates = c(8.8034, 53.0756)),
                buffer = 100)
ors_pois(geometry = geometry)

# alternative specification via bounding box
ors_pois(geometry = list(bbox = list(c(8.8034, 53.0756), c(8.8034, 53.0756)),
                         buffer = 100))

# POIs of given categories
ors_pois(geometry = geometry,
         limit = 200,
         sortby = "distance",
         filters = list(
           category_ids = c(180, 245)
         ))

# POIs of given category groups
ors_pois(geometry = geometry,
         limit = 200,
         sortby = "distance",
         filters = list(
           category_group_ids = 160
         ))

# POI Statistics
ors_pois("stats", geometry = geometry)}
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
