% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{ors_export}
\alias{ors_export}
\title{Openrouteservice Export}
\usage{
ors_export(
  bbox,
  profile = ors_profile(),
  ...,
  api_key = ors_api_key(),
  output = c("parsed", "text")
)
}
\arguments{
\item{bbox}{List of \verb{longitude, latitude} coordinate pairs defining the SW and NE corners of a rectangular area of interest, alternatively a two column \code{matrix} or \code{data.frame}.}

\item{profile}{Route profile, defaults to \code{"driving-car"}.}

\item{...}{Optional parameters as described \href{https://openrouteservice.org/dev/#/api-docs/v2/export/{profile}/post}{here}}

\item{api_key}{Character scalar containing openrouteservice API key}

\item{output}{Output format. By default the response is being parsed to a list-based R object}
}
\value{
Lists of graph nodes and edges contained in the provided bounding box and relevant for the given routing profile. The edge property \code{weight} represents travel time in seconds. The response is structured according to \code{output}:

\itemize{
\item for \code{"text"}, a character vector of length 1 re-encoded to UTF-8.
}

\itemize{
\item for \code{"parsed"}, a parsed R object.
}
}
\description{
Export the base graph for different modes of transport.
}
\examples{
\dontrun{
bbox <- list(
  c(8.681495, 49.41461),
  c(8.686507, 49.41943)
)

res <- ors_export(bbox)
}
}
\author{
Andrzej Oleś \href{mailto:andrzej.oles@gmail.com}{andrzej.oles@gmail.com}
}
