% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-ukdemo.R
\docType{data}
\name{ukdemo}
\alias{ukdemo}
\title{United Kingdom Demographic Data}
\format{
A data frame with 12 observations on the following 6 variables.
\describe{
\item{region}{Region in the United Kingdom}
\item{debt}{Average regional debt, not including mortgages, in pounds}
\item{unemployment}{Percent unemployment}
\item{house}{Average house price, in pounds}
\item{pay}{Average hourly pay, in pounds}
\item{rpi}{Retail price index, which is standardized to 100 for the entire UK,
and lower index scores correspond to lower prices}
}
}
\source{
The data was described in the Guardian Data Blog:
\url{https://www.theguardian.com/news/datablog/interactive/2011/oct/27/debt-money-expert-facts},
retrieved 2011-11-01.
}
\usage{
ukdemo
}
\description{
This data set comes from the Guardian's Data Blog and includes five
financial demographic variables.
}
\examples{

library(ggplot2)

ggplot(ukdemo, aes(x = pay, y = rpi)) +
  geom_point() +
  labs(x = "Average hourly pay", y = "Retail price index")

}
\references{
Guardian Data Blog
}
\keyword{datasets}
