% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/face.R, R/opencv.R
\name{ocv_face}
\alias{ocv_face}
\alias{ocv_facemask}
\alias{ocv_read}
\alias{ocv_write}
\alias{ocv_bitmap}
\alias{ocv_edges}
\alias{ocv_picture}
\alias{ocv_resize}
\alias{ocv_mog2}
\alias{ocv_knn}
\alias{ocv_hog}
\alias{ocv_blur}
\alias{ocv_sketch}
\alias{ocv_stylize}
\alias{ocv_markers}
\alias{ocv_info}
\alias{ocv_copyto}
\alias{ocv_display}
\alias{ocv_video}
\title{OpenCV Computer Vision}
\usage{
ocv_face(image)

ocv_facemask(image)

ocv_read(path)

ocv_write(image, path)

ocv_bitmap(image)

ocv_edges(image)

ocv_picture()

ocv_resize(image, width = 0, height = 0)

ocv_mog2(image)

ocv_knn(image)

ocv_hog(image)

ocv_blur(image, ksize = 5)

ocv_sketch(image, color = TRUE)

ocv_stylize(image)

ocv_markers(image)

ocv_info(image)

ocv_copyto(image, target, mask)

ocv_display(image)

ocv_video(filter)
}
\arguments{
\item{image}{a ocv image object}

\item{path}{image file such as png or jpeg}

\item{width}{output width in pixels}

\item{height}{output height in pixels}

\item{ksize}{size of blurring matrix}

\item{color}{true or false}

\item{target}{the output image}

\item{mask}{only copy pixels from the mask}

\item{filter}{an R function that takes and returns an opecv image}
}
\description{
Tools to experiment with computer vision algorithms. Use \link{ocv_read} and
\link{ocv_write} to load/save images on disk, or use \link{ocv_picture} / \link{ocv_video}
to use your webcam. In RSudio IDE the image objects will automatically be
displayed in the viewer pane.
}
\examples{
# Silly example
mona <- ocv_read('https://jeroen.github.io/images/monalisa.jpg')

# Edge detection
ocv_edges(mona)
ocv_markers(mona)

# Find face
faces <- ocv_face(mona)

# To show locations of faces
#facemask <- ocv_facemask(mona)
#attr(facemask, 'faces')
}
