% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/airbaseFindCode.R
\name{airbaseFindCode}
\alias{airbaseFindCode}
\title{Helper function to find EEA airbase site codes}
\usage{
airbaseFindCode(country = c("AL", "AT", "BA", "BE", "BG", "CH", "CY", "CZ",
  "DE", "DK", "EE", "ES", "FI", "FR", "GB", "GR", "HR", "HU", "IE", "IS", "IT",
  "LI", "LT", "LU", "LV", "ME", "MK", "MT", "NL", "NO", "PL", "PT", "RO", "RS",
  "SE", "SI", "SK", "TR"), site.type = c("background", "traffic",
  "industrial", "unknown"), area.type = c("rural", "urban", "suburban",
  "unknown"), local.code = NA, city = NA, site = NA, emep = NA,
  lat = c(-90, 90), lon = c(-180, 180))
}
\arguments{
\item{country}{A character or vector of characters representing country code.}

\item{site.type}{One of \dQuote{background}, \dQuote{traffic},
\dQuote{industrial}, \dQuote{unknown} representing the type of
site.}

\item{area.type}{The type of area in which the site is
located. Can be \dQuote{rural}, \dQuote{urban}, \dQuote{suburban},
\dQuote{unknown}.}

\item{local.code}{A character or vector of characters representing
the local site code. For example \dQuote{MY1} is the UK code for
Marylebone Road.}

\item{city}{A city name to search --- using character matching
(\code{grep}). The search string can be upper or lower case
e.g. \code{city = "london"}. To extract several cities
e.g. Copenhagen and Barcelona use \code{city = c("copenhagen",
"barcelona")}. Note that by default any matching characters are
returned, so \code{city = "london"} would also return Londonderry
(Northern Ireland).

Regular expression searches are very powerful and potentially
complicated. However there are a few useful tips. To match the
\emph{beginning} of a name use \sQuote{^}. So \code{city =
"^london"} would return London and Londonderry (both begin with
\sQuote{london}). To match the end of a name use \sQuote{$}, so
\code{city = "london$"} would just return London but not
Londonderry.

The cities chosen are printed to screen to make it easy to check
(and refine the search string) of the selected sites.}

\item{site}{The name of the site or sites to search, see
\code{city} for details of how to search.}

\item{emep}{Select an EMEP station. Can be \dQuote{yes},
\dQuote{no} or \code{NA} (the default, selects everything).}

\item{lat}{The latitude range to select in the form c(lower, upper).}

\item{lon}{The longitude range to select in the form c(lower, upper).}
}
\value{
A vector of airbase site codes that can be used directly
in \code{\link{importAirbase}}.
}
\description{
Helper function to find airbase site codes
}
\details{
This function helps to identify airbase site codes based on one or
more criteria. The criteria include country code, site type, local
site code, city, site name and latitude/longitude ranges.
}
\examples{
## select all sites in Denmark
\dontrun{sites <- airbaseFindCode(country = "DK")

## traffic sites in Germany and the UK
sites <- airbaseFindCode(country = c("DE", "GB"), site.type = "traffic")}
}
\author{
David Carslaw
}
\seealso{
\code{\link{importAirbase}},
\code{\link{airbaseFindCode}}, \code{\link{airbaseStats}} and
\code{\link{airbaseInfo}}
}

