% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CSMF.r
\name{getCSMF_accuracy}
\alias{getCSMF_accuracy}
\title{Calculate CSMF accuracy}
\usage{
getCSMF_accuracy(csmf, truth, undet = NULL)
}
\arguments{
\item{csmf}{a CSMF vector from \code{getCSMF} or a InSilicoVA fitted object.}

\item{truth}{a CSMF vectorof the true CSMF.
Default value to be 0.95.}

\item{undet}{name of the category denoting undetermined causes. Default to be NULL.}
}
\value{
a number (or vector if input is InSilicoVA fitted object) of CSMF accuracy as 1 - sum(abs(CSMF - CSMF_true)) / (2 * (1 - min(CSMF_true))).
}
\description{
Calculate CSMF accuracy
}
\examples{
csmf1 <- c(0.2, 0.3, 0.5)
csmf0 <- c(0.3, 0.3, 0.4)
acc <- getCSMF_accuracy(csmf1, csmf0)
}

