/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerEvaluationMonitor;
import opennlp.tools.chunker.ChunkerEvaluator;
import opennlp.tools.chunker.ChunkerFactory;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkerCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private FMeasure fmeasure = new FMeasure();
    private ChunkerEvaluationMonitor[] listeners;
    private ChunkerFactory chunkerFactory;

    @Deprecated
    public ChunkerCrossValidator(String languageCode, int cutoff, int iterations) {
        this.languageCode = languageCode;
        this.params = ModelUtil.createTrainingParameters(iterations, cutoff);
        this.listeners = null;
    }

    public ChunkerCrossValidator(String languageCode, TrainingParameters params, ChunkerEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = params;
        this.listeners = listeners;
    }

    public ChunkerCrossValidator(String languageCode, TrainingParameters params, ChunkerFactory factory, ChunkerEvaluationMonitor ... listeners) {
        this.chunkerFactory = factory;
        this.languageCode = languageCode;
        this.params = params;
        this.listeners = listeners;
    }

    public void evaluate(ObjectStream<ChunkSample> samples, int nFolds) throws IOException, InvalidFormatException, IOException {
        CrossValidationPartitioner<ChunkSample> partitioner = new CrossValidationPartitioner<ChunkSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<ChunkSample> trainingSampleStream = partitioner.next();
            ChunkerModel model = ChunkerME.train(this.languageCode, trainingSampleStream, this.params, this.chunkerFactory);
            ChunkerEvaluator evaluator = new ChunkerEvaluator(new ChunkerME(model, 10), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.fmeasure.mergeInto(evaluator.getFMeasure());
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

