/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.PlainTextByLineDataStream;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.TagDictionary;

public class BatchTagger {
    private static void usage() {
        System.err.println("Usage: BatchTagger [-dict dict_file] data_file model");
        System.err.println("This applies a model to the specified text file.");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            BatchTagger.usage();
        }
        int ai = 0;
        try {
            String dictFile = "";
            String tagDictFile = "";
            while (args[ai].startsWith("-")) {
                if (args[ai].equals("-dict")) {
                    if (++ai < args.length) {
                        dictFile = args[ai++];
                        continue;
                    }
                    BatchTagger.usage();
                    continue;
                }
                if (args[ai].equals("-tag_dict")) {
                    if (++ai < args.length) {
                        tagDictFile = args[ai++];
                        continue;
                    }
                    BatchTagger.usage();
                    continue;
                }
                System.err.println("Unknown option " + args[ai]);
                BatchTagger.usage();
            }
            Dictionary dict = new Dictionary(new FileInputStream(dictFile));
            File textFile = new File(args[ai++]);
            File modelFile = new File(args[ai++]);
            GISModel mod = new SuffixSensitiveGISModelReader(modelFile).getModel();
            POSTaggerME tagger = tagDictFile.equals("") ? new POSTaggerME((MaxentModel)mod, dict) : new POSTaggerME((MaxentModel)mod, dict, (TagDictionary)new POSDictionary(tagDictFile));
            PlainTextByLineDataStream text = new PlainTextByLineDataStream((Reader)new FileReader(textFile));
            while (text.hasNext()) {
                String str = (String)text.nextToken();
                System.out.println(tagger.tag(str));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

