/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.Parser;
import opennlp.tools.parser.ParserChunker;
import opennlp.tools.parser.ParserTagger;
import opennlp.tools.util.Heap;
import opennlp.tools.util.ListHeap;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.Span;

public abstract class AbstractBottomUpParser
implements Parser {
    protected int M;
    protected int K;
    protected double Q;
    public static final int defaultBeamSize = 20;
    public static final double defaultAdvancePercentage = 0.95;
    protected Heap completeParses;
    protected Heap odh;
    protected Heap ndh;
    protected HeadRules headRules;
    protected Set punctSet;
    public static final String TOP_NODE = "TOP";
    public static final String INC_NODE = "INC";
    public static final String TOK_NODE = "TK";
    public static final Integer ZERO = new Integer(0);
    public static final String START = "S-";
    public static final String CONT = "C-";
    public static final String OTHER = "O";
    public static final String COMPLETE = "c";
    public static final String INCOMPLETE = "i";
    protected ParserTagger tagger;
    protected ParserChunker chunker;
    protected boolean reportFailedParse;
    protected boolean createDerivationString = false;
    protected boolean debugOn = false;

    public AbstractBottomUpParser(ParserTagger tagger, ParserChunker chunker, HeadRules headRules, int beamSize, double advancePercentage) {
        this.tagger = tagger;
        this.chunker = chunker;
        this.M = beamSize;
        this.K = beamSize;
        this.Q = advancePercentage;
        this.reportFailedParse = true;
        this.headRules = headRules;
        this.punctSet = headRules.getPunctuationTags();
        this.odh = new ListHeap(this.K);
        this.ndh = new ListHeap(this.K);
        this.completeParses = new ListHeap(this.K);
    }

    public void setErrorReporting(boolean errorReporting) {
        this.reportFailedParse = errorReporting;
    }

    public static void setParents(Parse p) {
        Parse[] children = p.getChildren();
        for (int ci = 0; ci < children.length; ++ci) {
            children[ci].setParent(p);
            AbstractBottomUpParser.setParents(children[ci]);
        }
    }

    public static Parse[] collapsePunctuation(Parse[] chunks, Set punctSet) {
        ArrayList<Parse> collapsedParses = new ArrayList<Parse>(chunks.length);
        int lastNonPunct = -1;
        int nextNonPunct = -1;
        int cn = chunks.length;
        for (int ci = 0; ci < cn; ++ci) {
            if (punctSet.contains(chunks[ci].getType())) {
                if (lastNonPunct >= 0) {
                    chunks[lastNonPunct].addNextPunctuation(chunks[ci]);
                }
                for (nextNonPunct = ci + 1; nextNonPunct < cn && punctSet.contains(chunks[nextNonPunct].getType()); ++nextNonPunct) {
                }
                if (nextNonPunct >= cn) continue;
                chunks[nextNonPunct].addPreviousPunctuation(chunks[ci]);
                continue;
            }
            collapsedParses.add(chunks[ci]);
            lastNonPunct = ci;
        }
        if (collapsedParses.size() == chunks.length) {
            return chunks;
        }
        return collapsedParses.toArray(new Parse[collapsedParses.size()]);
    }

    protected abstract Parse[] advanceParses(Parse var1, double var2);

    protected abstract void advanceTop(Parse var1);

    public Parse[] parse(Parse tokens, int numParses) {
        if (this.createDerivationString) {
            tokens.setDerivation(new StringBuffer(100));
        }
        this.odh.clear();
        this.ndh.clear();
        this.completeParses.clear();
        int maxDerivationLength = 2 * tokens.getChildCount() + 3;
        this.odh.add(tokens);
        Parse guess = null;
        double minComplete = 2.0;
        double bestComplete = -100000.0;
        for (int derivationStage = 0; this.odh.size() > 0 && (this.completeParses.size() < this.M || ((Parse)this.odh.first()).getProb() < minComplete) && derivationStage < maxDerivationLength; ++derivationStage) {
            this.ndh = new ListHeap(this.K);
            Iterator pi = this.odh.iterator();
            for (int derivationRank = 0; pi.hasNext() && derivationRank < this.K; ++derivationRank) {
                Parse tp = (Parse)pi.next();
                if (guess == null && derivationStage == 2) {
                    guess = tp;
                }
                if (this.debugOn) {
                    System.out.print(derivationStage + " " + derivationRank + " " + tp.getProb());
                    tp.show();
                    System.out.println();
                }
                Parse[] nd = null;
                nd = 0 == derivationStage ? this.advanceTags(tp) : (1 == derivationStage ? (this.ndh.size() < this.K ? this.advanceChunks(tp, bestComplete) : this.advanceChunks(tp, ((Parse)this.ndh.last()).getProb())) : this.advanceParses(tp, this.Q));
                if (nd != null) {
                    int kl = nd.length;
                    for (int k = 0; k < kl; ++k) {
                        if (nd[k].complete()) {
                            this.advanceTop(nd[k]);
                            if (nd[k].getProb() > bestComplete) {
                                bestComplete = nd[k].getProb();
                            }
                            if (nd[k].getProb() < minComplete) {
                                minComplete = nd[k].getProb();
                            }
                            this.completeParses.add(nd[k]);
                            continue;
                        }
                        this.ndh.add(nd[k]);
                    }
                    continue;
                }
                if (this.reportFailedParse) {
                    System.err.println("Couldn't advance parse " + derivationStage + " stage " + derivationRank + "!\n");
                }
                this.advanceTop(tp);
                this.completeParses.add(tp);
            }
            this.odh = this.ndh;
        }
        if (this.completeParses.size() == 0) {
            if (this.reportFailedParse) {
                System.err.println("Couldn't find parse for: " + tokens);
            }
            return new Parse[]{guess};
        }
        if (numParses == 1) {
            return new Parse[]{(Parse)this.completeParses.first()};
        }
        ArrayList<Parse> topParses = new ArrayList<Parse>(numParses);
        while (!this.completeParses.isEmpty() && topParses.size() < numParses) {
            Parse tp = (Parse)this.completeParses.extract();
            topParses.add(tp);
        }
        return topParses.toArray(new Parse[topParses.size()]);
    }

    public Parse parse(Parse tokens) {
        Parse p = this.parse(tokens, 1)[0];
        AbstractBottomUpParser.setParents(p);
        return p;
    }

    protected Parse[] advanceChunks(Parse p, double minChunkScore) {
        Parse[] children = p.getChildren();
        String[] words = new String[children.length];
        String[] ptags = new String[words.length];
        double[] probs = new double[words.length];
        Parse sp = null;
        int il = children.length;
        for (int i = 0; i < il; ++i) {
            sp = children[i];
            words[i] = sp.getHead().toString();
            ptags[i] = sp.getType();
        }
        Sequence[] cs = this.chunker.topKSequences(words, ptags, minChunkScore - p.getProb());
        Parse[] newParses = new Parse[cs.length];
        int sl = cs.length;
        for (int si = 0; si < sl; ++si) {
            newParses[si] = (Parse)p.clone();
            if (this.createDerivationString) {
                newParses[si].getDerivation().append(si).append(".");
            }
            String[] tags = cs[si].getOutcomes().toArray(new String[words.length]);
            cs[si].getProbs(probs);
            int start = -1;
            int end = 0;
            String type = null;
            for (int j = 0; j <= tags.length; ++j) {
                if (j != tags.length) {
                    newParses[si].addProb(Math.log(probs[j]));
                }
                if (j != tags.length && tags[j].startsWith(CONT)) {
                    end = j;
                    continue;
                }
                if (type != null) {
                    Parse p1 = p.getChildren()[start];
                    Parse p2 = p.getChildren()[end];
                    Parse[] cons = new Parse[end - start + 1];
                    cons[0] = p1;
                    if (end - start != 0) {
                        cons[end - start] = p2;
                        for (int ci = 1; ci < end - start; ++ci) {
                            cons[ci] = p.getChildren()[ci + start];
                        }
                    }
                    Parse chunk = new Parse(p1.getText(), new Span(p1.getSpan().getStart(), p2.getSpan().getEnd()), type, 1.0, this.headRules.getHead(cons, type));
                    chunk.isChunk(true);
                    newParses[si].insert(chunk);
                }
                if (j == tags.length) continue;
                if (tags[j].startsWith(START)) {
                    type = tags[j].substring(START.length());
                    start = j;
                    end = j;
                    continue;
                }
                type = null;
            }
        }
        return newParses;
    }

    protected Parse[] advanceTags(Parse p) {
        Parse[] children = p.getChildren();
        String[] words = new String[children.length];
        double[] probs = new double[words.length];
        int il = children.length;
        for (int i = 0; i < il; ++i) {
            words[i] = children[i].toString();
        }
        Sequence[] ts = this.tagger.topKSequences(words);
        if (ts.length == 0) {
            System.err.println("no tag sequence");
        }
        Parse[] newParses = new Parse[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            String[] tags = ts[i].getOutcomes().toArray(new String[words.length]);
            ts[i].getProbs(probs);
            newParses[i] = (Parse)p.clone();
            if (this.createDerivationString) {
                newParses[i].getDerivation().append(i).append(".");
            }
            for (int j = 0; j < words.length; ++j) {
                Parse word = children[j];
                double prob = probs[j];
                newParses[i].insert(new Parse(word.getText(), word.getSpan(), tags[j], prob, j));
                newParses[i].addProb(Math.log(prob));
            }
        }
        return newParses;
    }

    protected int mapParseIndex(int index, Parse[] nonPunctParses, Parse[] parses) {
        int parseIndex = index;
        while (parses[parseIndex] != nonPunctParses[index]) {
            ++parseIndex;
        }
        return parseIndex;
    }
}

