/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.util.Span;

public class Parse
implements Cloneable,
Comparable {
    private String text;
    private Span span;
    private String type;
    private List parts;
    private Parse head;
    private String label;
    private Parse parent;
    private double prob;
    private StringBuffer derivation;
    private static Pattern typePattern = Pattern.compile("^([^ =-]+)");
    private static Pattern funTypePattern = Pattern.compile("^[^ =-]+-([^ =-]+)");
    private static Pattern tokenPattern = Pattern.compile("^[^ ()]+ ([^ ()]+)\\s*\\)");
    private Collection prevPunctSet;
    private Collection nextPunctSet;
    private static boolean useFunctionTags;

    public Object clone() {
        Parse p = new Parse(this.text, this.span, this.type, this.prob, this.head);
        p.parts = (List)((LinkedList)this.parts).clone();
        if (this.derivation != null) {
            p.derivation = new StringBuffer(100);
            p.derivation.append(this.derivation.toString());
        }
        p.label = this.label;
        return p;
    }

    public static void useFunctionTags(boolean uft) {
        useFunctionTags = uft;
    }

    public Parse(String text, Span span, String type, double p) {
        this.text = text;
        this.span = span;
        this.type = type;
        this.prob = p;
        this.head = this;
        this.parts = new LinkedList();
        this.label = null;
        this.parent = null;
    }

    public Parse(String text, Span span, String type, double p, Parse h) {
        this(text, span, type, p);
        this.head = h;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Collection getPreviousPunctuationSet() {
        return this.prevPunctSet;
    }

    public void addPreviousPunctuation(Parse punct) {
        if (this.prevPunctSet == null) {
            this.prevPunctSet = new LinkedHashSet();
        }
        this.prevPunctSet.add(punct);
    }

    public Collection getNextPunctuationSet() {
        return this.nextPunctSet;
    }

    public void addNextPunctuation(Parse punct) {
        if (this.nextPunctSet == null) {
            this.nextPunctSet = new LinkedHashSet();
        }
        this.nextPunctSet.add(punct);
    }

    public void setNextPunctuation(Collection punctSet) {
        this.nextPunctSet = punctSet;
    }

    public void setPrevPunctuation(Collection punctSet) {
        this.prevPunctSet = punctSet;
    }

    public void insert(Parse constituent) {
        int pi;
        Span ic = constituent.span;
        if (this.span.contains(ic)) {
            int pn = this.parts.size();
            for (pi = 0; pi < pn; ++pi) {
                Parse subPart = (Parse)this.parts.get(pi);
                Span sp = subPart.span;
                if (sp.getStart() >= ic.getEnd()) break;
                if (ic.contains(sp)) {
                    this.parts.remove(pi);
                    --pi;
                    constituent.parts.add(subPart);
                    subPart.setParent(constituent);
                    pn = this.parts.size();
                    continue;
                }
                if (!sp.contains(ic)) continue;
                subPart.insert(constituent);
                return;
            }
        } else {
            throw new InternalError("Inserting constituent not contained in the sentence!");
        }
        this.parts.add(pi, constituent);
        constituent.setParent(this);
    }

    public void show(StringBuffer sb) {
        int start = this.span.getStart();
        if (!this.type.equals("TK")) {
            sb.append("(");
            sb.append(this.type + " ");
        }
        for (Parse c : this.parts) {
            Span s = c.span;
            if (start < s.getStart()) {
                sb.append(this.text.substring(start, s.getStart()));
            }
            c.show(sb);
            start = s.getEnd();
        }
        sb.append(this.text.substring(start, this.span.getEnd()));
        if (!this.type.equals("TK")) {
            sb.append(")");
        }
    }

    public void show() {
        StringBuffer sb = new StringBuffer(this.text.length() * 4);
        this.show(sb);
        System.out.println(sb);
    }

    public double getTagSequenceProb() {
        if (this.parts.size() == 1 && ((Parse)this.parts.get((int)0)).type.equals("TK")) {
            return Math.log(this.prob);
        }
        if (this.parts.size() == 0) {
            System.err.println("Parse.getTagSequenceProb: Wrong base case!");
            return 0.0;
        }
        double sum = 0.0;
        Iterator pi = this.parts.iterator();
        while (pi.hasNext()) {
            sum += ((Parse)pi.next()).getTagSequenceProb();
        }
        return sum;
    }

    public boolean complete() {
        return this.parts.size() == 1;
    }

    public String toString() {
        return this.text.substring(this.span.getStart(), this.span.getEnd());
    }

    public String getText() {
        return this.text;
    }

    public Span getSpan() {
        return this.span;
    }

    public double getProb() {
        return this.prob;
    }

    public void addProb(double logProb) {
        this.prob += logProb;
    }

    public Parse[] getChildren() {
        return this.parts.toArray(new Parse[this.parts.size()]);
    }

    public void setChild(int index, String label) {
        Parse newChild = (Parse)((Parse)this.parts.get(index)).clone();
        newChild.setLabel(label);
        this.parts.set(index, newChild);
    }

    public int getChildCount() {
        return this.parts.size();
    }

    public int indexOf(Parse child) {
        return this.parts.indexOf(child);
    }

    public Parse getHead() {
        return this.head;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private static String getType(String rest) {
        if (rest.startsWith("-LCB-")) {
            return "-LCB-";
        }
        if (rest.startsWith("-RCB-")) {
            return "-RCB-";
        }
        if (rest.startsWith("-LRB-")) {
            return "-LRB-";
        }
        if (rest.startsWith("-RRB-")) {
            return "-RRB-";
        }
        Matcher typeMatcher = typePattern.matcher(rest);
        if (typeMatcher.find()) {
            Matcher funMatcher;
            String type = typeMatcher.group(1);
            if (useFunctionTags && (funMatcher = funTypePattern.matcher(rest)).find()) {
                String ftag = funMatcher.group(1);
                type = type + "-" + ftag;
            }
            return type;
        }
        return null;
    }

    private static String getToken(String rest) {
        Matcher tokenMatcher = tokenPattern.matcher(rest);
        if (tokenMatcher.find()) {
            return tokenMatcher.group(1);
        }
        return null;
    }

    public void updateHeads(HeadRules rules) {
        if (this.parts != null && this.parts.size() != 0) {
            int pn = this.parts.size();
            for (int pi = 0; pi < pn; ++pi) {
                Parse c = (Parse)this.parts.get(pi);
                c.updateHeads(rules);
            }
            this.head = rules.getHead(this.parts.toArray(new Parse[this.parts.size()]), this.type);
            if (this.head == null) {
                this.head = this;
            }
        } else {
            this.head = this;
        }
    }

    public static Parse parseParse(String parse) {
        Object[] parts;
        String type;
        StringBuffer text = new StringBuffer();
        int offset = 0;
        Stack<Object[]> stack = new Stack<Object[]>();
        LinkedList<Object[]> cons = new LinkedList<Object[]>();
        int cl = parse.length();
        for (int ci = 0; ci < cl; ++ci) {
            char c = parse.charAt(ci);
            if (c == '(') {
                String rest = parse.substring(ci + 1);
                type = Parse.getType(rest);
                if (type == null) {
                    System.err.println("null type for: " + rest);
                }
                String token = Parse.getToken(rest);
                stack.push(new Object[]{type, new Integer(offset)});
                if (token == null || type.equals("-NONE-")) continue;
                cons.add(new Object[]{"TK", new Span(offset, offset + token.length())});
                text.append(token).append(" ");
                offset += token.length() + 1;
                continue;
            }
            if (c != ')' || (type = (String)(parts = (Object[])stack.pop())[0]).equals("-NONE-")) continue;
            int start = (Integer)parts[1];
            cons.add(new Object[]{parts[0], new Span(start, offset - 1)});
        }
        String txt = text.toString();
        Parse p = new Parse(txt, new Span(0, txt.length()), "TOP", 1.0);
        for (int ci = 0; ci < cons.size(); ++ci) {
            parts = (Object[])cons.get(ci);
            type = (String)parts[0];
            if (type.equals("TOP")) continue;
            Parse con = new Parse(txt, (Span)parts[1], type, 1.0);
            p.insert(con);
        }
        return p;
    }

    public Parse getParent() {
        return this.parent;
    }

    public void setParent(Parse parent) {
        this.parent = parent;
    }

    public boolean isPosTag() {
        return this.parts.size() == 1 && ((Parse)this.parts.get(0)).getType().equals("TK");
    }

    public Parse[] getTagNodes() {
        LinkedList<Parse> tags = new LinkedList<Parse>();
        LinkedList nodes = new LinkedList();
        nodes.addAll(this.parts);
        while (nodes.size() != 0) {
            Parse p = (Parse)nodes.remove(0);
            if (p.isPosTag()) {
                tags.add(p);
                continue;
            }
            nodes.addAll(0, p.parts);
        }
        return tags.toArray(new Parse[tags.size()]);
    }

    public Parse getCommonParent(Parse node) {
        if (this == node) {
            return this.parent;
        }
        HashSet<Parse> parents = new HashSet<Parse>();
        for (Parse cparent = this; cparent != null; cparent = cparent.getParent()) {
            parents.add(cparent);
        }
        while (node != null) {
            if (parents.contains(node)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    public int compareTo(Object o) {
        Parse p = (Parse)o;
        if (this.getProb() > p.getProb()) {
            return -1;
        }
        if (this.getProb() < p.getProb()) {
            return 1;
        }
        return 0;
    }

    public StringBuffer getDerivation() {
        return this.derivation;
    }

    public void setDerivation(StringBuffer derivation) {
        this.derivation = derivation;
    }

    private void codeTree(Parse p, int[] levels) {
        Parse[] kids = p.getChildren();
        StringBuffer levelsBuff = new StringBuffer();
        levelsBuff.append("[");
        int[] nlevels = new int[levels.length + 1];
        for (int li = 0; li < levels.length; ++li) {
            nlevels[li] = levels[li];
            levelsBuff.append(levels[li]).append(".");
        }
        for (int ki = 0; ki < kids.length; ++ki) {
            nlevels[levels.length] = ki;
            System.out.println(levelsBuff.toString() + ki + "] " + kids[ki].getType() + " " + kids[ki].hashCode() + " -> " + kids[ki].getParent().hashCode() + " " + kids[ki].getParent().getType() + " " + kids[ki].toString());
            this.codeTree(kids[ki], nlevels);
        }
    }

    public void showCodeTree() {
        this.codeTree(this, new int[0]);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: Parse -fun head_rules < train_parses");
            System.err.println("Reads training parses (one-sentence-per-line) and displays parse structure.");
            System.exit(1);
        }
        int ai = 0;
        if (args[0].equals("-fun")) {
            Parse.useFunctionTags(true);
            ++ai;
        }
        opennlp.tools.lang.english.HeadRules rules = new opennlp.tools.lang.english.HeadRules(args[ai]);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String line = in.readLine();
        while (line != null) {
            Parse p = Parse.parseParse(line);
            p.updateHeads(rules);
            p.show();
            line = in.readLine();
        }
    }
}

