% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.R
\name{opal.resource_view_create}
\alias{opal.resource_view_create}
\title{Create an Opal view over a resource reference}
\usage{
opal.resource_view_create(
  opal,
  project,
  table,
  resource,
  type = "Participant",
  idColumn = NULL,
  profile = NULL
)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the view will be located.}

\item{table}{View name to be created.}

\item{resource}{Fully qualified resource name.}

\item{type}{Entity type, default is "Participant".}

\item{idColumn}{Name of the column which contains the entity identifiers. 
If not specified, the first column will be used.}

\item{profile}{R server profile to use for establishing the connection with the 
resource. If not specifed, the profile will guessed based on the resource definition.}
}
\description{
Create an Opal view if a table with same name does not already exist. The resource 
reference is required.The dictionary of the created view will be discovered at 
initialization time. Use \link{opal.table_dictionary_update} to apply a dictionary.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
# make a view over a resource
opal.resource_view_create(o, "CNSIM", "CNSIM4", resource = "RSRC.CNSIM1")
opal.resource_view_create(o, "CNSIM", "FEMALE_2439", 
                          resource = "RSRC.FEMALE_2439", idColumn = "Name")
opal.logout(o)
}
}
\seealso{
Other table functions: 
\code{\link{opal.resource_view_reconnect}()},
\code{\link{opal.table_create}()},
\code{\link{opal.table_delete}()},
\code{\link{opal.table_dictionary_get}()},
\code{\link{opal.table_dictionary_update}()},
\code{\link{opal.table_exists}()},
\code{\link{opal.table_export}()},
\code{\link{opal.table_get}()},
\code{\link{opal.table_import}()},
\code{\link{opal.table_perm_add}()},
\code{\link{opal.table_perm_delete}()},
\code{\link{opal.table_perm}()},
\code{\link{opal.table_save}()},
\code{\link{opal.table_truncate}()},
\code{\link{opal.table_view_create}()},
\code{\link{opal.table_view_update}()}
}
\concept{table functions}
