% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.profile_create}
\alias{dsadmin.profile_create}
\title{Create a DataSHIELD profile}
\usage{
dsadmin.profile_create(opal, name, cluster = "default", rParser = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{Name of the profile.}

\item{cluster}{Name of the R servers cluster to which the profile will be attached to. Default value is 'default'.}

\item{rParser}{Version of the DataSHIELD R parser that applies to this profile. If not
specified, the system's default one will be used. A valid version would be one of 'v1' or 'v2'.}
}
\description{
The created DataSHIELD profile will not be enabled and no access restrictions is applied.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.profile_create(o, name = 'survival', cluster = 'demo')
opal.logout(o)
}
}
\seealso{
Other DataSHIELD profiles: 
\code{\link{dsadmin.profile_access}()},
\code{\link{dsadmin.profile_delete}()},
\code{\link{dsadmin.profile_enable}()},
\code{\link{dsadmin.profile_exists}()},
\code{\link{dsadmin.profile_init}()},
\code{\link{dsadmin.profile_perm_add}()},
\code{\link{dsadmin.profile_perm_delete}()},
\code{\link{dsadmin.profile_perm}()},
\code{\link{dsadmin.profile_rparser}()},
\code{\link{dsadmin.profiles}()},
\code{\link{dsadmin.profile}()}
}
\concept{DataSHIELD profiles}
