% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.token.R
\name{opal.token_datashield_create}
\alias{opal.token_datashield_create}
\title{Create a personal access token for Datashield usage}
\usage{
opal.token_datashield_create(opal, name, projects = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{Name of the token}

\item{projects}{Vector of project names, to which the token applies. Default is NULL (all projects).}
}
\value{
The token value.
}
\description{
Create a personal access token for Datashield usage
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
token <- opal.token_datashield_create(o, 'ds-1')
opal.logout(o)
}
}
\seealso{
Other token functions: 
\code{\link{opal.token_delete}()},
\code{\link{opal.token_r_create}()},
\code{\link{opal.token_sql_create}()},
\code{\link{opal.tokens}()},
\code{\link{opal.token}()}
}
\concept{token functions}
