% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.r
\name{dsadmin.perm_add}
\alias{dsadmin.perm_add}
\title{Add or update a DataSHIELD permission}
\usage{
dsadmin.perm_add(opal, subject, type = "user", permission)
}
\arguments{
\item{opal}{Opal connection object.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}

\item{permission}{The permission to apply: use or administrate.}
}
\description{
Add or update a permission on the DataSHIELD service.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.perm_add(o, c('andrei', 'valentina'), 'user', 'use')
dsadmin.perm(o)
dsadmin.perm_delete(o, c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
