% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf2raw.R
\name{vcf2raw}
\alias{vcf2raw}
\title{Convert variants from a VCF file to OneMap file format}
\usage{
vcf2raw(input = NULL, output = NULL, cross = c("outcross",
  "f2 intercross", "f2 backcross", "ri self", "ri sib"), parent1 = NULL,
  parent2 = NULL, min_class = 1)
}
\arguments{
\item{input}{path to the input VCF file.}

\item{output}{path to the output OneMap file.}

\item{cross}{type of cross. Must be one of: \code{"outcross"} for full-sibs;
\code{"f2 intercross"} for an F2 intercross progeny; \code{"f2 backcross"};
\code{"ri self"} for recombinant inbred lines by self-mating; or
\code{"ri sib"} for recombinant inbred lines by sib-mating.}

\item{parent1}{\code{string} or \code{vector} of \code{strings} specifying
sample ID(s) of the first parent.}

\item{parent2}{\code{string} or \code{vector} of \code{strings} specifying
sample ID(s) of the second parent.}

\item{min_class}{a real number between 0.0 and 1.0. For each parent and each
variant site, defines the proportion of parent samples that must be of the
same genotype for it to be assigned to the corresponding parent.}
}
\description{
Converts data from a standard VCF (Variant Call Format) file to the input
format required by OneMap, while trying to identify the appropriate marker
segregation patterns.
}
\details{
The input VCF file must be sorted, compressed and tabix indexed. Please check
functions \code{bgzip} and \code{indexTabix} of package \code{Rsamtools} for
details.

Each variant in the VCF file is processed independently. Only biallelic SNPs
and indels for diploid variant sites are considered.

Genotype information on the parents is required for all cross types. For
full-sib progenies, both outbred parents must be genotyped. For backcrosses,
F2 intercrosses and recombinant inbred lines, the \emph{original inbred
lines} must be genotyped. Particularly for backcross progenies, the
\emph{recurrent line must be provided as the first parent} in the function
arguments.

First, samples corresponding to both parents of the progeny are parsed and
their genotypes identified, given that their replicates are concordant above
a threshold given by \code{min_class}. This allows replicates of the parents
to be used, which is common in sequencing plates. In detail, each parent will
be called an heterozygote only if
\eqn{min\_class * number \ of \ replicates}{[min_class * number of replicates]}
samples or more are heterozygous. The same is valid for homozygous calls.
Whenever there are different genotypes among replicates, heterozygosity is
checked first. The default value (\code{1.0}) requires that all replicates be
of the same genotype. If each parent is represented by a single sample, this
parameter has no effect.

Next, marker type is determined based on parental genotypes. Finally, progeny
genotypes are identified and output is produced. Variants for which parent
genotypes cannot be determined are discarded.

Reference sequence ID and position for each variant site are stored as special
fields denoted \code{CHROM} and \code{POS}.
}
\examples{

  \dontrun{
    vcf2raw(input="your_VCF_file.vcf.gz",
            output="your_OneMap_file.raw",
            cross="your_cross_type",
            parent1=c("PAR1_sample1", "PAR1_sample2"),
            parent2=c("PAR2_sample1", "PAR2_sample2", "PAR2_sample3"),
            min_class=0.5) # for parent1, a single heterozygote replicate results
                           # in a heterozygote genotype call; for parent2, at
                           # least two samples have to be concordant
  }
  
}
\seealso{
\code{read_onemap} for a description of the OneMap file format.
}
\author{
Gabriel R A Margarido, \email{gramarga@gmail.com}
}
\keyword{IO}
