% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_lod.R
\name{suggest_lod}
\alias{suggest_lod}
\title{Suggests a LOD Score for two point tests}
\usage{
suggest_lod(x)
}
\arguments{
\item{x}{an object of class \code{onemap}}
}
\value{
the suggested LOD to be used for testing linkage
}
\description{
It suggests a LOD Score for declaring statistical significance for two-point tests
for linkage between all pairs of markers, considering that multiple tests are being performed.
}
\details{
In a somehow naive approach, the function calculates the number of two-point tests that
will be performed for all markers in the data set, and then using this to calculate
the global alpha required to control type I error using Bonferroni's correction.

From this global alpha, the corresponding quantile from the chi-square distribution is taken
and then converted to LOD Score.

This can be seen as just an initial approximation to help users to select a LOD Score for two
point tests.
}
\examples{
data(mapmaker_example_bc) # Loads a fake backcross dataset installed with onemap
suggest_lod(mapmaker_example_bc) # An value that should be used to start the analysis

}
